<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Basic\beRouter;
use App\System\Basic\beViewer;
use App\System\Model\AuthModel;
use App\System\Model\CurrencyModel;
use App\System\Model\InvoiceItemModel;
use App\System\Model\InvoiceModel;
use App\System\Model\MessageTemplateModel;
use App\System\Model\MessageTemplateTranslationsModel;
use App\System\Model\ProductAddonModulesModel;
use App\System\Model\ProductAddonTranslationsModel;
use App\System\Model\ProductModel;
use App\System\Model\ProductModulesModel;
use App\System\Model\ProductTranslationsModel;
use App\System\Model\ServerModel;
use App\System\Model\UserInfoModel;
use App\System\Model\UserLogModel;
use App\System\Model\UserProductCancellationsModel;
use App\System\Model\UserProductExtensionsModel;
use App\System\Model\UserProductLogsModel;
use App\System\Model\UserProductModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beAlert;
use App\System\Vendor\beLanguage;
use App\System\Vendor\beMail;
use App\System\Vendor\beModule;
use App\System\Vendor\bePlugin;
use App\System\Vendor\beSms;

class OrderController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","list") -> "9101db8b3142404cffbb15d98d4e633a" RANDOM
    public function list(){
        $user = Auth::beGetUser();
        $productlist = ProductModel::beSelect("be_products.pid,pt.pname")->beWhere("pt.lid",$user["lid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGetAll();
        $products = [];
        foreach($productlist as $product){
            $products[$product["pid"]] = $product["pname"];
        }
        return beGetView("admin.order.list",["products" => $products]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","add") -> "693124c9e83f454f57d2e4f611fe1c9c" RANDOM
    public function add(){
        $user = Auth::beGetUser();
        $products = ProductModel::beSelect("be_products.pid,pname")->beWhere("lid",$user["lid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGetAll();
        $orderstatus = UserProductModel::beGetUserProductStatus();
        return beGetView("admin.order.add",["products" => $products,"orderstatus" => $orderstatus]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","add_post") -> "ffadff297f0a97a2330891c534e5ce93" RANDOM
    public function add_post(){
        beLanguage::beReadLang("order");
        beLanguage::beReadLang("product");
        beLanguage::beReadLang("module");
        $pid = (int)$_POST["pid"];
        $product = ProductModel::beSelect("pid,pmodule")->beWhere("pid",$pid)->beGet();
        if(!$product){
            return beAjaxError(["message" => beGetLang("product_not_found")]);
        }
        $module = $product["pmodule"];
        $uid = (int)$_POST["order_uid"];
        $user = Auth::beGetUser($uid);
        $status = (int)$_POST["order_status"];
        $onmodule = (int)$_POST["order_onmodule"];
        $itemcount = (int)$_POST["order_count"];
        $cart = new CartController;
        $item = $cart->calculate_basket($_POST,0,0,$uid);
        if(!$item["status"]){
            return beAjaxError(["message" => $item["message"]]);
        }
        $productsprice = $item["productprice"];
        $updata = [];
        if($module){
            beModule::beLoadModule("product.{$module}");
            $configs = beModule::beModuleOrderConfig($module);
            foreach($configs as $key => $data){
                switch($data["type"]){
                    case "select" :
                        $value = $_POST[$key];
                        if(!in_array($value,array_keys($data["values"]))){
                            return beAjaxError(["message" => beGetLang("module_field_select_not_correct",["name" => $data["name"]])]);
                        }
                        $updata[$key] = $value;
                        break;
                    case "multpileselect" :
                        $valuelist = $_POST[$key];
                        $values = [];
                        foreach($valuelist as $value){
                            if(!in_array($value,array_keys($data["values"]))){
                                return beAjaxError(["message" => beGetLang("module_field_select_not_correct",["name" => $data["name"]])]);
                            }
                            $values[] = $value;
                        }
                        $updata[$key] = $values;
                        break;
                    case "integer" :
                        $value = (int)$_POST[$key];
                        if(isset($data["requirements"]["min"]) && $data["requirements"]["min"] > $value){
                            return beAjaxError(["message" => beGetLang("module_field_min_num",["name" => $data["name"],"value" => $data["requirements"]["min"]])]);
                        }
                        if(isset($data["requirements"]["max"]) && $data["requirements"]["max"] < $value){
                            return beAjaxError(["message" => beGetLang("module_field_max_num",["name" => $data["name"],"value" => $data["requirements"]["max"]])]);
                        }
                        $updata[$key] = $value;
                        break;
                    case "string" :
                        $value = htmlspecialchars($_POST[$key]);
                        $length = strlen($value);
                        if(isset($data["requirements"]["min"]) && $data["requirements"]["min"] > $length){
                            return beAjaxError(["message" => beGetLang("module_field_min_length",["name" => $data["name"],"value" => $data["requirements"]["min"]])]);
                        }
                        if(isset($data["requirements"]["max"]) && $data["requirements"]["max"] < $length){
                            return beAjaxError(["message" => beGetLang("module_field_max_length",["name" => $data["name"],"value" => $data["requirements"]["max"]])]);
                        }
                        $updata[$key] = $value;
                        break;
                    case "float" :
                        $value = (float)$_POST[$key];
                        if(isset($data["requirements"]["min"]) && $data["requirements"]["min"] > $value){
                            return beAjaxError(["message" => beGetLang("module_field_min_num",["name" => $data["name"],"value" => $data["requirements"]["min"]])]);
                        }
                        if(isset($data["requirements"]["max"]) && $data["requirements"]["max"] < $value){
                            return beAjaxError(["message" => beGetLang("module_field_max_num",["name" => $data["name"],"value" => $data["requirements"]["max"]])]);
                        }
                        $updata[$key] = $value;
                        break;
                    case "date" :
                        $value = strtotime($_POST[$key]);
                        $updata[$key] = $value;
                        break;
                }
            }
        }
        $cart = new CartController;
        $periodtimes = ProductModel::beGetPeriodsTimes();
        $systime = $item["optionsdata"]["period"]["time"]*$periodtimes[$item["optionsdata"]["period"]["period"]];
        ProductModel::beUpdate(["psold" => $item["product"]["psold"]+$itemcount,"pactive" => $item["product"]["pactive"]+$itemcount])->beWhere("pid",$item["product"]["pid"])->beExecute();
        for($i = 0; $i < $itemcount; $i++){
            UserProductModel::beInsert([
                "uid" => $user["uid"],
                "cid" => $user["cid"],
                "pid" => $item["product"]["pid"],
                "sid" => $item["product"]["sid"],
                "upname" => $item["product"]["pname"],
                "updata" => json_encode($updata,JSON_UNESCAPED_UNICODE),
                "upoptions" => json_encode($item["optionsdata"],JSON_UNESCAPED_UNICODE),
                "upstatus" => $status,
                "upprice" => $cart->calculate_basket_nextprice($item["optionsdata"],$user["cid"]),
                "uptaxrate" => $item["taxrate"],
                "upmodule" => $item["product"]["pmodule"],
                "upstime" => BE_TIME,
                "upntime" => $systime ? BE_TIME+$systime-259200:0,
                "upetime" => $systime ? BE_TIME+$systime:0
            ]);
        }
        return beAjaxSuccess(["message" => beGetLang("order_created"),"url" => beGetRoute("admin.user.show",["uid" => $user["uid"]])]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","show") -> "7b4045693e59c662956fe59bb1b81dbc" RANDOM
    public function show($upid){
        beLanguage::beReadLang("order");
        beLanguage::beReadLang("product");
        $mainfile = BE_APPPATH."resources/cache/version.json";
        $build = 0;
        if(file_exists($mainfile)){
            $system = file_get_contents($mainfile);
            $system = json_decode($system,true);
            $build = $system["build"];
        }
        global $be;
        $settings = $be->settings;
        $response = ConnectionController::beSendRequestControlPanel([
            "method" => "checkuser",
            "data" => [
                "version" => $build,
                "cid" => $settings["system_id"],
                "ctoken" => $settings["system_token"],
                "secret" => $settings["system_secret"]
            ]
        ]);
        if(!$response["status"]){
            beError("Lisans Hatası",$response["message"]);
        }
        $user = Auth::beGetUser();
        $userproduct = UserProductModel::beTable("be_user_products as up")->beSelect("up.*,u.lid,u.name,u.surname,u.email")->beWhere("upid",$upid)->beJoin("INNER JOIN be_users as u ON u.uid = up.uid")->beGet();
        if(!$userproduct){
            beError(beGetLang("order"),beGetLang("order_not_found"));
        }
        $upoptions = json_decode($userproduct["upoptions"],true);
        $upsystemdata = json_decode($userproduct["upsystemdata"],true);
        unset($userproduct["upoptions"]);
        unset($userproduct["upsystemdata"]);
        $periods = ProductModel::beGetPeriods();
        $currencies = CurrencyModel::beGetCurrencies("cid,cname,cicon");
        $cancellationstatus = UserProductCancellationsModel::beGetUserProductCancellationStatus();
        $cancellationtypes = UserProductCancellationsModel::beGetUserProductCancellationTypes();
        $userproductcancellations = UserProductCancellationsModel::beTable("be_user_product_cancellations as upc")->beSelect("upc.*,u.name,u.surname")->beWhere("upid",$userproduct["upid"])->beJoin("INNER JOIN be_users as u ON u.uid = upc.uid")->beGetAll();
        $userproductlogs = UserProductLogsModel::beTable("be_user_product_logs as upl")->beSelect("upl.uid,upl.uplid,upltype,upldata,uplipaddress,upldateline,u.name,u.surname")->beWhere("upid",$userproduct["upid"])->beJoin("INNER JOIN be_users as u ON u.uid = upl.uid")->beGetAll();
        $products = ProductModel::beTable("be_products as p")->beSelect("p.pid,pt.pname")->beWhere("pt.lid",$user["lid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = p.pid")->beGetAll();
        $product = ProductModel::beTable("be_products as p")->beSelect("p.pid,p.pperiods,p.paddons,p.pstock,p.pactive,p.psold,p.pextend,p.pdateline,pt.pname")->beWhere("p.pid",$userproduct["pid"])->beWhere("pt.lid",$user["lid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = p.pid")->beGet();
        $this->beSetOrderMessages($user["lid"],$userproductlogs);
        $addons = json_decode($product["paddons"],true);
        if($addons){
            $productaddonslist = ProductAddonTranslationsModel::beSelect("paid,paname,patype,paoptions,paovveridecurrency")->beWhere("lid",$user["lid"])->beWhere("paid",$addons,"IN")->beWhere("pastatus",1)->beGetAll();
            if(!$productaddonslist){
                beError(beGetLang("product"),beGetLang("product_addons_not_found"));
            }
            $productaddons = [];
            foreach($productaddonslist as $productaddon){
                $productaddons[$productaddon["paid"]] = $productaddon;
            }
        }
        $status = UserProductModel::beGetUserProductStatus();
        $extensions = UserProductExtensionsModel::beWhere("upid",$userproduct["upid"])->beGetAll();
        $unittypes = InvoiceModel::beGetUnitTypes();
        $invoicelist = InvoiceModel::beSelect("iid,cid,idescription,idateline")->beWhere("uid",$userproduct["uid"])->beWhere("itype","2")->beWhere("istatus","0")->beGetAll();
        $invoices = [];
        foreach($invoicelist as $invoice){
            $found = false;
            $invoiceitems = InvoiceItemModel::beSelect("iiid,cid,iiobjectid,iiname,iiunitprice,iiunitcount,iiunittype")->beWhere("iid",$invoice["iid"])->beWhere("iiobject","ExtendOrder")->beGetAll();
            foreach($invoiceitems as $item){
                if($item["iiobjectid"] == $userproduct["upid"]){
                    $found = true;
                }   
            }
            if($found){
                $invoices[(int)$invoice["iid"]] = array_merge($invoice,["invoiceitems" => $invoiceitems]);
            }
        }
        $modules = beModule::beLoadModules("product");
        return beGetView("admin.order.show",["order" => $userproduct,"extensions" => $extensions,"userproductlogs" => $userproductlogs,"userproductcancellations" => $userproductcancellations,"cancellationstatus" => $cancellationstatus,"cancellationtypes" => $cancellationtypes,"product" => $product,"products" => $products,"unittypes" => $unittypes,"currencies" => $currencies,"status" => $status,"upoptions" => $upoptions,"upsystemdata" => $upsystemdata,"periods" => $periods,"productaddons" => $productaddons,"invoices" => $invoices,"modules" => $modules]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","status_post") -> "3a875a995dfdaf61eda46981ade6d70d" RANDOM
    public function status_post(){
        beLanguage::beReadLang("order");
        beLanguage::beReadLang("usergroup");
        $mainfile = BE_APPPATH."resources/cache/version.json";
        $build = 0;
        if(file_exists($mainfile)){
            $system = file_get_contents($mainfile);
            $system = json_decode($system,true);
            $build = $system["build"];
        }
        global $be;
        $settings = $be->settings;
        $response = ConnectionController::beSendRequestControlPanel([
            "method" => "checkuser",
            "data" => [
                "version" => $build,
                "cid" => $settings["system_id"],
                "ctoken" => $settings["system_token"],
                "secret" => $settings["system_secret"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $user = Auth::beGetUser();
        $upid = (int)$_POST["upid"];
        $upids = $_POST["upids"];
        if(!$upids && $upid){
            $upids[] = $upid;
        }
        if(empty($upids)){
            return beAjaxError(["message" => beGetLang("order_not_selected")]);
        }
        $status = (int)$_POST["status"];
        $onmodule = (int)$_POST["onmodule"];
        $statustypes = [-1,0,1,2];
        if(!in_array($status,$statustypes)){
            return beAjaxError(["message" => beGetLang("order_status_not_found")]);
        }
        $userproducts = UserProductModel::beTable("be_user_products as up")->beSelect("up.*,u.lid,u.name,u.surname,u.email")->beWhere("upid",$upids,"IN")->beJoin("INNER JOIN be_users as u ON u.uid = up.uid")->beGetAll();
        if(!$userproducts){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        foreach($userproducts as $userproduct){
            UserProductModel::beUpdate(["upprocess" => "0"])->beWhere("upid",$userproduct["upid"])->beExecute();
            $sitename = beGetConfig("sitename");
            $upsystemdata = json_decode($userproduct["upsystemdata"],true);
            $upoptions = json_decode($userproduct["upoptions"],true);
            $product = ProductModel::beSelect("be_products.*,pt.pname")->beWhere("be_products.pid",$userproduct["pid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGet();
            if($onmodule){
                if(!beCheckPermission("admin_order_status_on_module",0)){
                    return beAjaxError(["message" => beGetLang("usergroup_permission_denied",["permission" => "admin_order_status_on_module"])]);
                }
                $functionnames = [-1 => "terminate",0 => "suspend",1 => "waiting",2 => "unsuspend"];
                if(!$userproduct["upmodule"]){
                    return beAjaxError(["message" => beGetLang("order_module_not_found")]);
                }
                if($userproduct["upstatus"] == 1 && $status == 2){
                    $functionnames[2] = "create";
                }
                $productmoduleslist = ProductModulesModel::beSelect("pmid,pmmodulekey,pmvalue")->beWhere("pid",$product["pid"])->beWhere("pmmodule",$userproduct["upmodule"])->beGetAll();
                $productmodules = [];
                foreach($productmoduleslist as $productmodule){
                    $productmodules[$productmodule["pmmodulekey"]] = $productmodule["pmvalue"];
                }
                $product["paddons"] = json_decode($product["paddons"],true);
                $addonmodules = [];
                if($product["paddons"]){
                    $productaddons = ProductAddonTranslationsModel::beSelect("patid,paid")->beWhere("paid",$product["paddons"],"IN")->beWhere("lid",$user["lid"])->beGetAll();
                    foreach($upoptions as $key => $upoption){
                        foreach($productaddons as $productaddon){
                            if($key == $productaddon["paid"]){
                                $productaddonmodules = ProductAddonModulesModel::beSelect("pamodulekey,pavalue")->beWhere("patid",$productaddon["patid"])->beWhere("pamodule",$userproduct["upmodule"])->beWhere("pakey",$upoption["key"])->beGetAll();
                                foreach($productaddonmodules as $productaddonmodule){
                                    $addonmodules[$productaddonmodule["pamodulekey"]][] = $productaddonmodule["pavalue"];
                                }
                            }
                        }
                    }
                }
                $data = [
                    "userproduct" => $userproduct,
                    "productmodules" => $productmodules,
                    "addonmodules" => $addonmodules                          
                ];
                if($userproduct["sid"]){
                    $server = ServerModel::beWhere("sid",$userproduct["sid"])->beGet();
                    $server["spassword"] = beDecryptData($server["spassword"]);
                    $data["server"] = $server;
                }
                beModule::beLoadModule("product.{$userproduct['upmodule']}");
                if(beModule::beCheckModuleFunction($userproduct["upmodule"],$functionnames[$status])){
                    $response = beModule::beRunModuleFunction($userproduct["upmodule"],$functionnames[$status],$data);
                    if(!$response["status"]){
                        $upsystemdata["error"] = $response["message"];
                        UserProductModel::beUpdate([
                            "upsystemdata" => json_encode($upsystemdata,JSON_UNESCAPED_UNICODE)
                        ])->beWhere("upid",$userproduct["upid"])->beExecute();
                        UserProductLogsModel::beInsert([
                            "uid" => $userproduct["uid"],
                            "upid" => $userproduct["upid"],
                            "upltype" => "order_".$functionnames[$status]."_module_error",
                            "upldata" => json_encode([
                                "message" => $response["message"]
                            ],JSON_UNESCAPED_UNICODE),
                            "upldateline" => BE_TIME
                        ]);
                        return beAjaxError(["message" => $response["message"]]);
                    }
                    UserProductLogsModel::beInsert([
                        "uid" => $userproduct["uid"],
                        "upid" => $userproduct["upid"],
                        "upltype" => "order_".$functionnames[$status]."_module",
                        "upldata" => json_encode([
                            "message" => $response["message"]
                        ],JSON_UNESCAPED_UNICODE),
                        "upldateline" => BE_TIME
                    ]);
                    switch($status){
                        case -1 : 
                            $messages = MessageTemplateModel::beGetMessages("order_terminated",1)["order_terminated"];
                            $userinfo = UserInfoModel::beSelect("uid,uisettings")->beWhere("uid",$userproduct["uid"])->beGet();
                            $uisettings = json_decode($userinfo["uisettings"],true);
                            if($messages["alert"] && $uisettings["notification_alert"]){
                                $message = str_replace(["{sitename}","{productname}","{namesurname}"],[$sitename,$userproduct["upname"]." ".$userproduct["uptag"],$userproduct["name"]." ".$userproduct["surname"]],$messages["alert"]["mttmessage"]);
                                beAlert::beCreateAlert(json_encode(["message" => $message],JSON_UNESCAPED_UNICODE),beGetRoute("client.userproduct.userproducts"),$userinfo["uid"]);
                            }
                            if($messages["sms"] && $uisettings["sms_alert"]){
                                $message = str_replace(["{sitename}","{productname}","{namesurname}"],[$sitename,$userproduct["upname"]." ".$userproduct["uptag"],$userproduct["name"]." ".$userproduct["surname"]],$messages["sms"]["mttmessage"]);
                                beSms::beCreateSms($message,1,$userinfo["uid"]);
                            }
                            if($messages["mail"] && $uisettings["mail_alert"]){
                                $message = str_replace(["{sitename}","{productname}","{namesurname}"],[$sitename,$userproduct["upname"]." ".$userproduct["uptag"],$userproduct["name"]." ".$userproduct["surname"]],$messages["mail"]["mttmessage"]);
                                beMail::beCreateMail($messages["mail"]["mttsubject"],$message,2,1,$userinfo["uid"]);
                            }
                            break;
                        case 0 : 
                            $messages = MessageTemplateModel::beGetMessages("order_suspended",1)["order_suspended"];
                            $userinfo = UserInfoModel::beSelect("uid,uisettings")->beWhere("uid",$userproduct["uid"])->beGet();
                            $uisettings = json_decode($userinfo["uisettings"],true);
                            if($messages["alert"] && $uisettings["notification_alert"]){
                                $message = str_replace(["{sitename}","{productname}","{namesurname}"],[$sitename,$userproduct["upname"]." ".$userproduct["uptag"],$userproduct["name"]." ".$userproduct["surname"]],$messages["alert"]["mttmessage"]);
                                beAlert::beCreateAlert(json_encode(["message" => $message],JSON_UNESCAPED_UNICODE),beGetRoute("client.userproduct.userproducts"),$userinfo["uid"]);
                            }
                            if($messages["sms"] && $uisettings["sms_alert"]){
                                $message = str_replace(["{sitename}","{productname}","{namesurname}"],[$sitename,$userproduct["upname"]." ".$userproduct["uptag"],$userproduct["name"]." ".$userproduct["surname"]],$messages["sms"]["mttmessage"]);
                                beSms::beCreateSms($message,1,$userinfo["uid"]);
                            }
                            if($messages["mail"] && $uisettings["mail_alert"]){
                                $message = str_replace(["{sitename}","{productname}","{namesurname}"],[$sitename,$userproduct["upname"]." ".$userproduct["uptag"],$userproduct["name"]." ".$userproduct["surname"]],$messages["mail"]["mttmessage"]);
                                beMail::beCreateMail($messages["mail"]["mttsubject"],$message,2,1,$userinfo["uid"]);
                            }
                            break;
                        case 2 : 
                            $messages = MessageTemplateModel::beGetMessages("order_unsuspended",1)["order_unsuspended"];
                            $userinfo = UserInfoModel::beSelect("uid,uisettings")->beWhere("uid",$userproduct["uid"])->beGet();
                            $uisettings = json_decode($userinfo["uisettings"],true);
                            if($messages["alert"] && $uisettings["notification_alert"]){
                                $message = str_replace(["{sitename}","{productname}","{namesurname}"],[$sitename,$userproduct["upname"]." ".$userproduct["uptag"],$userproduct["name"]." ".$userproduct["surname"]],$messages["alert"]["mttmessage"]);
                                beAlert::beCreateAlert(json_encode(["message" => $message],JSON_UNESCAPED_UNICODE),beGetRoute("client.userproduct.userproducts"),$userinfo["uid"]);
                            }
                            if($messages["sms"] && $uisettings["sms_alert"]){
                                $message = str_replace(["{sitename}","{productname}","{namesurname}"],[$sitename,$userproduct["upname"]." ".$userproduct["uptag"],$userproduct["name"]." ".$userproduct["surname"]],$messages["sms"]["mttmessage"]);
                                beSms::beCreateSms($message,1,$userinfo["uid"]);
                            }
                            if($messages["mail"] && $uisettings["mail_alert"]){
                                $message = str_replace(["{sitename}","{productname}","{namesurname}"],[$sitename,$userproduct["upname"]." ".$userproduct["uptag"],$userproduct["name"]." ".$userproduct["surname"]],$messages["mail"]["mttmessage"]);
                                beMail::beCreateMail($messages["mail"]["mttsubject"],$message,2,1,$userinfo["uid"]);
                            }
                            break;
                    }
                }
            }
            UserProductModel::beUpdate([
                "upstatus" => $status
            ])->beWhere("upid",$userproduct["upid"])->beExecute();
            if($status == -1){
                $invoices = InvoiceModel::beSelect("iid")->beWhere("uid",$userproduct["uid"])->beWhere("itype","2")->beWhere("istatus","0")->beGetAll();
                foreach($invoices as $invoice){
                    $invoiceitem = InvoiceItemModel::beSelect("iiid")->beWhere("iid",$invoice["iid"])->beWhere("iiobject","ExtendOrder")->beWhere("iiobjectid",$userproduct["upid"])->beGet();
                    if($invoiceitem){
                        InvoiceModel::beUpdate(["istatus" => "-1"])->beWhere("iid",$invoice["iid"])->beExecute();     
                        break;
                    }  
                }    
                if($product["pactive"]-1 < 1){
                    $product["pactive"] = 0;
                }
                ProductModel::beUpdate(["pactive" => $product["pactive"]-1])->beWhere("pid",$product["pid"])->beExecute();
            }
        }
        return beAjaxSuccess(["message" => beGetLang("order_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","namesave_post") -> "f16e6a38738d146ccd4329c5cc0743db" RANDOM
    public function namesave_post(){
        beLanguage::beReadLang("order");
        $user = Auth::beGetUser();
        $upid = (int)$_POST["upid"];
        $userproduct = UserProductModel::beSelect("upid,upname,uptag")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $pid = (int)$_POST["product"];
        $product = ProductModel::beSelect("pid")->beWhere("pid",$pid)->beGet();
        if(!$product){
            return beAjaxError(["message" => beGetLang("product_not_found")]);
        }
        $name = htmlspecialchars($_POST["name"]);
        $tag = htmlentities($_POST["tag"]);
        if(empty($name)){
            return beAjaxError(["message" => beGetLang("order_name_empty")]);
        }
        UserProductModel::beUpdate([
            "pid" => $product["pid"],
            "upname" => $name,
            "uptag" => $tag
        ])->beWhere("upid",$userproduct["upid"])->beExecute();
        UserProductLogsModel::beInsert([
            "uid" => $user["uid"],
            "upid" => $userproduct["upid"],
            "upltype" => "name_edit",
            "upldata" => json_encode([
                "old_name" => $userproduct["upname"],
                "old_tag" => $userproduct["uptag"],
                "new_name" => $name,
                "new_tag" => $tag
            ]),
            "uplipaddress" => beRouter::$beUserIP,
            "upldateline" => BE_TIME
        ]);
        return beAjaxSuccess(["message" => beGetLang("order_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","notesave_post") -> "ec1cea91fbdc32cdd9c5b7cf91ecaabb" RANDOM
    public function notesave_post(){
        beLanguage::beReadLang("order");
        $user = Auth::beGetUser();
        $upid = (int)$_POST["upid"];
        $userproduct = UserProductModel::beSelect("upid")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $note = htmlspecialchars($_POST["note"]);
        UserProductModel::beUpdate([
            "upnote" => $note
        ])->beWhere("upid",$userproduct["upid"])->beExecute();
        UserProductLogsModel::beInsert([
            "uid" => $user["uid"],
            "upid" => $userproduct["upid"],
            "upltype" => "note_edit",
            "upldata" => "",
            "uplipaddress" => beRouter::$beUserIP,
            "upldateline" => BE_TIME
        ]);
        return beAjaxSuccess(["message" => beGetLang("order_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","pricesave_post") -> "2801461cf084be3da4359910e008fb1d" RANDOM
    public function pricesave_post(){
        beLanguage::beReadLang("order");
        beLanguage::beReadLang("currency");
        $user = Auth::beGetUser();
        $upid = (int)$_POST["upid"];
        $userproduct = UserProductModel::beSelect("upid,upprice,uptaxrate,upcalcprice,upoptions")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $price = (float)$_POST["price"];
        if($price < 0 ){
            $price = 0;
        }
        $taxrate = (int)$_POST["taxrate"];
        if($taxrate < 0){
            $taxrate = 0;
        }
        $cid = (int)$_POST["currency"];
        if(!CurrencyModel::beGetCurrencies("cid",$cid)){
            return beAjaxError(["message" => beGetLang("currency_not_found")]);
        }
        $calcprice = $_POST["calcprice"];
        if(!in_array($calcprice,["product","special"])){
            return beAjaxError(["message" => beGetLang("order_price_method_not_found")]);
        }
        $upbill = isset($_POST["upbill"]) ? "1":"0";
        UserProductLogsModel::beInsert([
            "uid" => $user["uid"],
            "upid" => $userproduct["upid"],
            "upltype" => "price_edit",
            "upldata" => json_encode([
                "cid" => $cid,
                "old_price" => (float)$userproduct["upprice"],
                "old_rate" => (int)$userproduct["uptaxrate"],
                "old_calcprice" => $userproduct["upcalcprice"],
                "new_price" => $price,
                "new_rate" => $taxrate,
                "new_calcprice" => $calcprice,
            ]),
            "uplipaddress" => beRouter::$beUserIP,
            "upldateline" => BE_TIME
        ]);
        UserProductModel::beUpdate([
            "cid" => $cid,
            "upprice" => $price,
            "uptaxrate" => $taxrate,
            "upcalcprice" => $calcprice,
            "upbill" => $upbill
        ])->beWhere("upid",$userproduct["upid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("order_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","timesave_post") -> "a8d4615c605837968ea5c260b77d3571" RANDOM
    public function timesave_post(){
        beLanguage::beReadLang("order");
        $upid = (int)$_POST["upid"];
        $userproduct = UserProductModel::beSelect("upid,upprice,uptaxrate,upcalcprice,upoptions")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $upstime = strtotime($_POST["upstime"]);
        if(!$upstime){
            return beAjaxError(["message" => beGetLang("order_time_empty")]);
        }
        $upntime = strtotime($_POST["upntime"]);
        if(!$upntime){
            return beAjaxError(["message" => beGetLang("order_time_empty")]);
        }
        $upetime = strtotime($_POST["upetime"]);
        if(!$upetime){
            return beAjaxError(["message" => beGetLang("order_time_empty")]);
        }
        UserProductModel::beUpdate([
            "upstime" => $upstime,
            "upntime" => $upntime,
            "upetime" => $upetime
        ])->beWhere("upid",$userproduct["upid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("order_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","invoicecreate_post") -> "4463638da3be3b884149510b4227b182" RANDOM
    public function invoicecreate_post(){
        beLanguage::beReadLang("usergroup");
        $user = Auth::beGetUser();
        $upid = (int)$_POST["upid"];
        $userproduct = UserProductModel::beSelect("upid,upstatus")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => "Belirtilen sipariş sistemde bulunamadı!"]);
        }
        switch($userproduct["upstatus"]){
            case 0 :
            case 1 :
            case 2 :
                if(!beCheckPermission("admin_invoice_add",0)){
                    return beAjaxError(["message" => beGetLang("usergroup_permission_denied",["permission" => "admin_invoice_add"])]);
                }
                $response = $this->create_order_invoice($upid,"extend",true,(int)$user["uid"]);
                if(!$response["status"]){
                    return beAjaxError(["message" => $response["message"]]);
                }
                return beAjaxSuccess(["message" => $response["message"]]);
                break;
        }
    }
    //@ioncube.dk beEncrypt("be_diyocp","optionsinfo_post") -> "705fa9411517087c9cfa422c4e56636b" RANDOM
    public function optionsinfo_post(){
        beLanguage::beReadLang("order");
        beLanguage::beReadLang("product");
        $user = Auth::beGetUser();
        $upid = (int)$_POST["upid"];
        $paid = (int)$_POST["paid"];
        $optionkey = (int)$_POST["option"];
        $userproduct = UserProductModel::beSelect("upid,upoptions")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $upoptions = json_decode($userproduct["upoptions"],true);
        $productaddon = ProductAddonTranslationsModel::beSelect("paid,paoptions,paovveridecurrency")->beWhere("lid",$user["lid"])->beWhere("paid",$paid)->beWhere("pastatus",1)->beGet();
        if(!$productaddon){
            return beAjaxError(["message" => beGetLang("product_addons_not_found")]);
        }
        $productaddon["paoptions"] = json_decode($productaddon["paoptions"],true);
        if(!$productaddon["paoptions"][$optionkey]){
            return beAjaxError(["message" => beGetLang("order_option_not_found")]);
        }
        $addon = $productaddon["paoptions"][$optionkey];
        if($upoptions["period"]["period"] != $addon["operiod"]){
            $addon["operiodcounter"] = ProductModel::beConvertPeriods($addon["operiod"],$upoptions["period"]["period"]);
        }
        else{
            $addon["operiodcounter"] = $addon["operiodtime"];
        }
        $currencies = CurrencyModel::beGetCurrencies("cid,cname,cicon");
        $html = beGetView("admin.order.addon",["addon" => $addon,"paid" => $productaddon["paid"],"currencies" => $currencies]);
        return beAjaxSuccess(["message" => beGetLang("order_updated"),"html" => $html]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","optionsinfo_post") -> "705fa9411517087c9cfa422c4e56636b" RANDOM
    public function optionssave_post(){
        beLanguage::beReadLang("order");
        beLanguage::beReadLang("product");
        beLanguage::beReadLang("currency");
        $user = Auth::beGetUser();
        $upid = (int)$_POST["upid"];
        $userproduct = UserProductModel::beTable("be_user_products as up")->beSelect("up.upid,up.pid,up.updata,up.upoptions,up.upmodule,u.lid,u.cid")->beWhere("up.upid",$upid)->beJoin("INNER JOIN be_users as u ON u.uid = up.uid")->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $upoptions = json_decode($userproduct["upoptions"],true);
        unset($userproduct["upoptions"]);
        $currencies = CurrencyModel::beGetCurrencies("cid");
        $product = ProductModel::beSelect("pid,pperiods,paddons")->beWhere("pid",$userproduct["pid"])->beGet();
        $addons = json_decode($product["paddons"],true);
        if($upoptions["period"]){
            $key = (int)$_POST["period"];
            if($key != $upoptions["period"]){
                $periods = json_decode($product["pperiods"],true)[$user["lid"]];
                if(!array_key_exists($key,$periods)){
                    return ["status" => false,"message" => beGetLang("product_period_not_found")];
                }
                $newperiod = $periods[$key];
                $upoptions["period"]["key"] = $key;
                $upoptions["period"]["price"] = $newperiod["oprice"];
                $upoptions["period"]["currency"] = $newperiod["ocid"];
                $upoptions["period"]["periodcounter"] = $newperiod["operiodtime"];
                $upoptions["period"]["periodfullcounter"] = $newperiod["operiodtime"];
                $upoptions["period"]["time"] = $newperiod["operiodtime"];
                $upoptions["period"]["period"] = $newperiod["operiod"];
                $cart = new CartController();
                $newprice = $cart->calculate_basket_nextprice($upoptions,$userproduct["cid"]);
                UserProductModel::beUpdate(["upoptions" => json_encode($upoptions,JSON_UNESCAPED_UNICODE),"upprice" => $newprice])->beWhere("upid",$userproduct["upid"])->beExecute();
            }
        }
        if($addons){
            $productaddonslist = ProductAddonTranslationsModel::beSelect("paid,paname,pacode,patype,paoptions,paovveridecurrency")->beWhere("lid",$user["lid"])->beWhere("paid",$addons,"IN")->beWhere("pastatus",1)->beGetAll();
            if(!$productaddonslist){
                return beAjaxError(["message" => beGetLang("product_addons_not_found")]);
            }
            foreach($productaddonslist as $productaddon){
                $paid = $productaddon["paid"];
                $paoptions = json_decode($productaddon["paoptions"],true);
                if(!empty($_POST[$paid])){
                    $key = $_POST[$paid];
                    if($productaddon["patype"] == "select"){
                        if(!$paoptions[$key]){
                            return beAjaxError(["message" => beGetLang("order_option_not_found")]);
                        }
                        $price = (float)$_POST["price".$paid];
                        if($price < 0){
                            $price = 0;
                        }
                        $price = round($price,2);
                        $currency = $_POST["currency".$paid];
                        if(!$currencies[$currency]){
                            return beAjaxError(["message" => beGetLang("currency_not_found")]);
                        }
                        $periodcounter = $_POST["periodcounter".$paid];
                        if($periodcounter !== "0"){
                            $periodcounter = explode("/",$periodcounter);
                            if(count($periodcounter) != 2){
                                return beAjaxError(["message" => beGetLang("order_option_time_empty")]);
                            }
                        }
                        else{
                            $periodcounter = [
                                0 => 0,
                                1 => 0
                            ];
                        }
                    }
                    switch($productaddon["patype"]){
                        case "select" :
                            $addon = $paoptions[$key];
                            $upoptions[$paid] = [
                                "key" => $key,
                                "name" => $addon["oname"],
                                "price" => $price,
                                "currency" => $currency,
                                "periodcounter" => (int)$periodcounter[0],
                                "periodfullcounter" => (int)$periodcounter[1],
                                "time" => $addon["operiodtime"],
                                "period" => $addon["operiod"]
                            ];
                            break;
                        case "text" :
                            $upoptions[$paid] = [
                                "key" => $key
                            ];
                            break;
                    }
                    if($productaddon["pacode"]){
                        $upoptions[$paid]["code"] = $productaddon["pacode"];
                    }
                }
                else{
                    unset($upoptions[$paid]);
                }
            }
            $cart = new CartController();
            $newprice = $cart->calculate_basket_nextprice($upoptions,$userproduct["cid"]);
            if($userproduct["upmodule"]){
                beModule::beLoadModule("product.{$userproduct['upmodule']}");
                if(beModule::beCheckModuleFunction($userproduct["upmodule"],"invoice_price")){
                    $response = beModule::beRunModuleFunction($userproduct["upmodule"],"invoice_price",[
                        "userproduct" => $userproduct,
                        "product" => $product,
                        "price" => $newprice
                    ]);
                    $newprice = $response["price"];
                }
            }
            UserProductLogsModel::beInsert([
                "uid" => $user["uid"],
                "upid" => $userproduct["upid"],
                "upltype" => "option_edit",
                "upldata" => json_encode($upoptions,JSON_UNESCAPED_UNICODE),
                "uplipaddress" => beRouter::$beUserIP,
                "upldateline" => BE_TIME
            ]);
            UserProductModel::beUpdate(["upoptions" => json_encode($upoptions,JSON_UNESCAPED_UNICODE),"upprice" => $newprice])->beWhere("upid",$userproduct["upid"])->beExecute();
        }
        return beAjaxSuccess(["message" => beGetLang("order_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","automation_post") -> "335d2ad9b599a2381ca94d702da4e764" RANDOM
    public function automation_post(){
        beLanguage::beReadLang("order");
        $mainfile = BE_APPPATH."resources/cache/version.json";
        $build = 0;
        if(file_exists($mainfile)){
            $system = file_get_contents($mainfile);
            $system = json_decode($system,true);
            $build = $system["build"];
        }
        global $be;
        $settings = $be->settings;
        $response = ConnectionController::beSendRequestControlPanel([
            "method" => "checkuser",
            "data" => [
                "version" => $build,
                "cid" => $settings["system_id"],
                "ctoken" => $settings["system_token"],
                "secret" => $settings["system_secret"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $upid = (int)$_POST["upid"];
        $module = $_POST["module"];
        $userproduct = UserProductModel::beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        if($userproduct["upmodule"] && !$module){
            $module = $userproduct["upmodule"];
        }
        if(!$module){
            return beAjaxError(["message" => beGetLang("order_module_not_found")]);
        }
        $user = Auth::beGetUser($userproduct["upid"],"lid");
        $upoptions = json_decode($userproduct["upoptions"],true);
        $product = ProductModel::beSelect("be_products.*,pt.pname")->beWhere("be_products.pid",$userproduct["pid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGet();
        $productmoduleslist = ProductModulesModel::beSelect("pmid,pmmodulekey,pmvalue")->beWhere("pid",$product["pid"])->beWhere("pmmodule",$userproduct["upmodule"])->beGetAll();
        $productmodules = [];
        foreach($productmoduleslist as $productmodule){
            $productmodules[$productmodule["pmmodulekey"]] = $productmodule["pmvalue"];
        }
        $product["paddons"] = json_decode($product["paddons"],true);
        if($product["paddons"]){
            $productaddons = ProductAddonTranslationsModel::beSelect("patid,paid")->beWhere("paid",$product["paddons"],"IN")->beWhere("lid",$user["lid"])->beGetAll();
            $addonmodules = [];
            foreach($upoptions as $key => $upoption){
                foreach($productaddons as $productaddon){
                    if($key == $productaddon["paid"]){
                        $productaddonmodules = ProductAddonModulesModel::beSelect("pamodulekey,pavalue")->beWhere("patid",$productaddon["patid"])->beWhere("pamodule",$userproduct["upmodule"])->beWhere("pakey",$upoption["key"])->beGetAll();
                        foreach($productaddonmodules as $productaddonmodule){
                            $addonmodules[$productaddonmodule["pamodulekey"]][] = $productaddonmodule["pavalue"];
                        }
                    }
                }
            }
        }
        $data = [
            "userproduct" => $userproduct,
            "productmodules" => $productmodules,
            "addonmodules" => $addonmodules                          
        ];
        if($userproduct["sid"]){
            $server = ServerModel::beWhere("sid",$userproduct["sid"])->beGet();
            $server["spassword"] = beDecryptData($server["spassword"]);
            $data["server"] = $server;
        }
        $updata = json_decode($userproduct["updata"],true);
        beModule::beLoadModule("product.{$module}");
        $configs = beModule::beModuleOrderConfig($module);
        $contentup = "";
        $contentdown = "";
        $maindata = $data;
        if(beModule::beCheckModuleFunction($module,"content_up")){
            $contentup = beModule::beRunModuleFunction($module,"content_up",$maindata);
        }
        $contentup = bePlugin::beRunHook("admin_order_automation_content_up",array_merge($maindata,["contentup" => $contentup]))["contentup"];
        $maindata = $data;
        if(beModule::beCheckModuleFunction($module,"content_down")){
            $contentdown = beModule::beRunModuleFunction($module,"content_down",$maindata);
        }
        $contentdown = bePlugin::beRunHook("admin_order_automation_content_up",array_merge($maindata,["contentdown" => $contentdown]))["contentdown"];
        $automation = beGetView("admin.order.automation",["configs" => $configs,"updata" => $updata]);
        return beAjaxSuccess(["automation" => $automation,"contentup" => $contentup,"contentdown" => $contentdown]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","automationsave_post") -> "dcd0479b4e0cc145816a71c183babaf7" RANDOM
    public function automationsave_post(){
        beLanguage::beReadLang("order");
        $upid = (int)$_POST["upid"];
        $module = $_POST["module"];
        $userproduct = UserProductModel::beSelect("upid,sid,updata,upmodule")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $updata = json_decode($userproduct["updata"],true);
        if($userproduct["upmodule"] && !$module){
            $module = $userproduct["upmodule"];
        }
        beModule::beLoadModule("product.{$module}");
        $configs = beModule::beModuleOrderConfig($module);
        foreach($configs as $key => $data){
            switch($data["type"]){
                case "select" :
                    $value = $_POST[$key];
                    if(!in_array($value,array_keys($data["values"]))){
                        return beAjaxError(["message" => beGetLang("module_field_select_not_correct",["name" => $data["name"]])]);
                    }
                    $updata[$key] = $value;
                    break;
                case "multpileselect" :
                    $valuelist = $_POST[$key];
                    $values = [];
                    foreach($valuelist as $value){
                        if(!in_array($value,array_keys($data["values"]))){
                            return beAjaxError(["message" => beGetLang("module_field_select_not_correct",["name" => $data["name"]])]);
                        }
                        $values[] = $value;
                    }
                    $updata[$key] = $values;
                    break;
                case "integer" :
                    $value = (int)$_POST[$key];
                    if(isset($data["requirements"]["min"]) && $data["requirements"]["min"] > $value){
                        return beAjaxError(["message" => beGetLang("module_field_min_num",["name" => $data["name"],"value" => $data["requirements"]["min"]])]);
                    }
                    if(isset($data["requirements"]["max"]) && $data["requirements"]["max"] < $value){
                        return beAjaxError(["message" => beGetLang("module_field_max_num",["name" => $data["name"],"value" => $data["requirements"]["max"]])]);
                    }
                    $updata[$key] = $value;
                    break;
                case "string" :
                    $value = htmlspecialchars($_POST[$key]);
                    $length = strlen($value);
                    if(isset($data["requirements"]["min"]) && $data["requirements"]["min"] > $length){
                        return beAjaxError(["message" => beGetLang("module_field_min_length",["name" => $data["name"],"value" => $data["requirements"]["min"]])]);
                    }
                    if(isset($data["requirements"]["max"]) && $data["requirements"]["max"] < $length){
                        return beAjaxError(["message" => beGetLang("module_field_max_length",["name" => $data["name"],"value" => $data["requirements"]["max"]])]);
                    }
                    $updata[$key] = $value;
                    break;
                case "float" :
                    $value = (float)$_POST[$key];
                    if(isset($data["requirements"]["min"]) && $data["requirements"]["min"] > $value){
                        return beAjaxError(["message" => beGetLang("module_field_min_num",["name" => $data["name"],"value" => $data["requirements"]["min"]])]);
                    }
                    if(isset($data["requirements"]["max"]) && $data["requirements"]["max"] < $value){
                        return beAjaxError(["message" => beGetLang("module_field_max_num",["name" => $data["name"],"value" => $data["requirements"]["max"]])]);
                    }
                    $updata[$key] = $value;
                    break;
                case "date" :
                    $value = strtotime($_POST[$key]);
                    $updata[$key] = $value;
                    break;
            }
        }
        $updatedata = ["updata" => json_encode($updata,JSON_UNESCAPED_UNICODE),"upmodule" => $module];
        $server = ServerModel::beSelect("sid")->beWhere("smodule",$module)->beGet();
        if($server){
            if($userproduct["sid"] != $server["sid"]){
                $updatedata["sid"] = $server["sid"];
            }
        }
        UserProductModel::beUpdate($updatedata)->beWhere("upid",$userproduct["upid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("order_updated")]);
    }
    public function automationmodule_post(){
        $mainfile = BE_APPPATH."resources/cache/version.json";
        $build = 0;
        if(file_exists($mainfile)){
            $system = file_get_contents($mainfile);
            $system = json_decode($system,true);
            $build = $system["build"];
        }
        global $be;
        $settings = $be->settings;
        $response = ConnectionController::beSendRequestControlPanel([
            "method" => "checkuser",
            "data" => [
                "version" => $build,
                "cid" => $settings["system_id"],
                "ctoken" => $settings["system_token"],
                "secret" => $settings["system_secret"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $upid = (int)$_POST["upid"];
        $function = $_POST["function"];
        $module_vars = $_POST["module_vars"];
        $userproduct = UserProductModel::beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $upoptions = json_decode($userproduct["upoptions"],true);
        $product = ProductModel::beSelect("be_products.*,pt.pname")->beWhere("be_products.pid",$userproduct["pid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGet();
        $productmoduleslist = ProductModulesModel::beSelect("pmid,pmmodulekey,pmvalue")->beWhere("pid",$product["pid"])->beWhere("pmmodule",$userproduct["upmodule"])->beGetAll();
        $productmodules = [];
        foreach($productmoduleslist as $productmodule){
            $productmodules[$productmodule["pmmodulekey"]] = $productmodule["pmvalue"];
        }
        $product["paddons"] = json_decode($product["paddons"],true);
        $addonmodules = [];
        if($product["paddons"]){
            $productaddons = ProductAddonTranslationsModel::beSelect("patid,paid")->beWhere("paid",$product["paddons"],"IN")->beGetAll();
            foreach($upoptions as $key => $upoption){
                foreach($productaddons as $productaddon){
                    if($key == $productaddon["paid"]){
                        $productaddonmodules = ProductAddonModulesModel::beSelect("pamodulekey,pavalue")->beWhere("patid",$productaddon["patid"])->beWhere("pamodule",$userproduct["upmodule"])->beWhere("pakey",$upoption["key"])->beGetAll();
                        foreach($productaddonmodules as $productaddonmodule){
                            $addonmodules[$productaddonmodule["pamodulekey"]][] = $productaddonmodule["pavalue"];
                        }
                    }
                }
            }
        }
        $data = [
            "userproduct" => $userproduct,
            "productmodules" => $productmodules,
            "addonmodules" => $addonmodules,
            "module_vars" => $module_vars              
        ];
        if($userproduct["sid"]){
            $server = ServerModel::beWhere("sid",$userproduct["sid"])->beGet();
            $server["spassword"] = beDecryptData($server["spassword"]);
            $data["server"] = $server;
        }
        beModule::beLoadModule("product.{$userproduct['upmodule']}");
        if(!beModule::beCheckModuleFunction($userproduct["upmodule"],$function)){
            return beAjaxError(["message" => "Modülde belirtilen fonksiyon bulunamadı lütfen modülü kontrol edin!"]);
        }
        $response = beModule::beRunModuleFunction($userproduct["upmodule"],$function,$data);
        if(!is_array($response)){
            $response = json_decode($response,true);
        }
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => $response["message"]]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","extensionadd_post") -> "b6b0bffe58294d10fbf6ee45700a8cc9" RANDOM
    public function extensionadd_post(){
        beLanguage::beReadLang("order");
        $upid = (int)$_POST["upid"];
        $userproduct = UserProductModel::beSelect("upid")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $upeid = UserProductExtensionsModel::beInsert([
            "upid" => $upid,
            "upedateline" => BE_TIME
        ]);
        return beAjaxSuccess(["message" => beGetLang("order_extension_created"),"upeid" => $upeid]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","extensionsave_post") -> "4125fdbc3bb562b2749ff5d4e052bdeb" RANDOM
    public function extensionsave_post(){
        beLanguage::beReadLang("order");
        beLanguage::beReadLang("invoice");
        beLanguage::beReadLang("currency");
        $upid = (int)$_POST["upid"];
        $upeid = (int)$_POST["upeid"];
        $userproductextension = UserProductExtensionsModel::beSelect("upeid")->beWhere("upeid",$upeid)->beWhere("upid",$upid)->beGet();
        if(!$userproductextension){
            return beAjaxError(["message" => beGetLang("order_extension_not_found")]);
        }
        $extension = $_POST["extension"][$upeid];
        $unittypes = InvoiceModel::beGetUnitTypes();
        $currencies = CurrencyModel::beGetCurrencies("cid");
        $rowname = htmlspecialchars($extension["rowName"]);
        if(!$rowname){
            return beAjaxError(["message" => beGetLang("order_extension_name_empty")]);
        }
        $description = htmlspecialchars($extension["rowDescription"]);
        $price = (double)$extension["rowPrice"];
        $count = $extension["rowCount"];
        $tax = (int)$extension["rowTax"];
        $unit = $extension["rowUnitType"];
        $type = $extension["rowType"];
        $status = (int)$extension["rowStatus"];
        if(!$unittypes[$unit]){
            return beAjaxError(["message" => beGetLang("invoice_unit_not_found")]);
        }
        $cid = (int)$extension["rowCurrency"];
        if(!$currencies[$cid]){
            return beAjaxError(["message" => beGetLang("currnecy_not_found")]);
        }
        UserProductExtensionsModel::beUpdate([
            "cid" => $cid,
            "upename" => $rowname,
            "upedescription" => $description,
            "upeunitcount" => $count,
            "upeunitprice" => $price,
            "upeunittype" => $unit,
            "uperate" => $tax,
            "upetype" => $type,
            "upestatus" => $status,
        ])->beWhere("upeid",$userproductextension["upeid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("order_extension_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","extensiondelete_post") -> "e18dae4a06fb09bf96fbde045b3e8251" RANDOM
    public function extensiondelete_post(){
        beLanguage::beReadLang("order");
        $upid = (int)$_POST["upid"];
        $upeid = (int)$_POST["upeid"];
        $userproductextension = UserProductExtensionsModel::beSelect("upeid,upename")->beWhere("upeid",$upeid)->beWhere("upid",$upid)->beGet();
        if(!$userproductextension){
            return beAjaxError(["message" => beGetLang("order_extension_not_found")]);
        }
        UserProductExtensionsModel::beDelete()->beWhere("upeid",$upeid)->beExecute();
        return beAjaxSuccess(["message" => beGetLang("order_extension_deleted")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","transfer_post") -> "fd086d8e938213635429a2f6453ca81e" RANDOM
    public function transfer_post(){
        beLanguage::beReadLang("order");
        beLanguage::beReadLang("user");
        $user = Auth::beGetUser();
        $upid = (int)$_POST["upid"];
        $userproduct = UserProductModel::beSelect("upid,uid")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        $newuid = (int)$_POST["user"];
        $newuser = AuthModel::beSelect("uid")->beWhere("uid",$newuid)->beGet();
        if(!$newuser){
            return beAjaxError(["message" => beGetLang("user_not_found")]);
        }
        UserProductModel::beUpdate([
            "uid" => $newuser["uid"],
        ])->beWhere("upid",$userproduct["upid"])->beExecute();
        UserProductLogsModel::beInsert([
            "uid" => $user["uid"],
            "upid" => $userproduct["upid"],
            "upltype" => "transfer",
            "upldata" => json_encode([
                "old_uid" => (int)$userproduct["uid"],
                "new_uid" => (int)$newuser["uid"]
            ]),
            "uplipaddress" => beRouter::$beUserIP,
            "upldateline" => BE_TIME
        ]);
        return beAjaxSuccess(["message" => beGetLang("order_transfered")]);
    }
    public function cancel_post(){
        beLanguage::beReadLang("order");
        $status = (int)$_POST["status"];
        $upcid = (int)$_POST["upcid"];
        $cancellation = UserProductCancellationsModel::beSelect("upcid,upid")->beWhere("upcid",$upcid)->beGet();
        if(!$cancellation){
            return beAjaxError(["message" => beGetLang("order_cancellation_not_found")]);
        }
        $userproduct = UserProductModel::beSelect("upid")->beWhere("upid",$cancellation["upid"])->beGet();
        if(!$userproduct){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        UserProductCancellationsModel::beUpdate(["upcstatus" => $status])->beWhere("upcid",$cancellation["upcid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("order_updated")]);
    }
    public function create_order_invoice($upid,$type,$force = false,$admin_uid = 0){
        beLanguage::beReadLang("order");
        beLanguage::beReadLang("product");
        beLanguage::beReadLang("invoice");
        $userproduct = UserProductModel::beSelect("upid,uid,cid,pid,upname,uptag,updata,upoptions,upstatus,upprice,uptaxrate,upprocess,upmodule,upetime")->beWhere("upid",$upid)->beGet();
        if(!$userproduct){
            return ["status" => false,"message" => beGetLang("order_not_found")];
        }
        UserProductModel::beUpdate(["upprocess" => "1"])->beWhere("upid",$userproduct["upid"])->beExecute();
        $updata = json_decode($userproduct["updata"],true);
        $upoptions = json_decode($userproduct["upoptions"],true);
        $product = ProductModel::beSelect("be_products.*,pt.pname")->beWhere("be_products.pid",$userproduct["pid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGet();
        $pdata = json_decode($product["pdata"],true);
        $poptions = json_decode($product["poptions"],true);
        switch($type){
            case "extend" :
                if($product["pextend"] != 1){
                    UserProductModel::beUpdate(["upprocess" => "0"])->beWhere("upid",$userproduct["upid"])->beExecute();
                    return ["status" => false,"message" => beGetLang("product_cant_extend")];
                }
                if(!$force && $product["pextendmanuel"] != 1){
                    UserProductModel::beUpdate(["upprocess" => "0"])->beWhere("upid",$userproduct["upid"])->beExecute();
                    return ["status" => false,"message" => beGetLang("product_can_extend_by_system")];
                }
                if(!$userproduct["upetime"]){
                    UserProductModel::beUpdate(["upprocess" => "0"])->beWhere("upid",$userproduct["upid"])->beExecute();
                    return ["status" => false,"message" => beGetLang("product_cant_extend")];     
                }    
                $invoices = InvoiceModel::beSelect("iid")->beWhere("uid",$userproduct["uid"])->beWhere("itype","2")->beWhere("istatus","0")->beGetAll();
                foreach($invoices as $invoice){
                    $invoiceitem = InvoiceItemModel::beSelect("iiid")->beWhere("iid",$invoice["iid"])->beWhere("iiobject","ExtendOrder")->beWhere("iiobjectid",$userproduct["upid"])->beGet();
                    if($invoiceitem){
                        UserProductModel::beUpdate(["upprocess" => "0"])->beWhere("upid",$userproduct["upid"])->beExecute();
                        return ["status" => false,"message" => "Müşterinin hali hazırda ürün uzatım faturası bulunmakta!","iid" => $invoice["iid"]];
                    }  
                }
                $invoiceitem = InvoiceItemModel::beSelect("iid")->beWhere("iiobjectid",$userproduct["upid"])->beWhere("iiobject","Upgrade")->beOrder("iiid","DESC")->beLimit(1)->beGet();
                if($invoiceitem){
                    $invoice = InvoiceModel::beSelect("iid")->beWhere("iid",$invoiceitem["iid"])->beWhere("istatus","0")->beGet();
                    if($invoice){
                        InvoiceModel::beUpdate(["istatus" => "-1"])->beWhere("iid",$invoice["iid"])->beExecute();
                    }
                } 
                if($userproduct["upmodule"]){
                    beModule::beLoadModule("product.{$userproduct['upmodule']}");
                    if(beModule::beCheckModuleFunction($userproduct["upmodule"],"extend")){
                        $response = beModule::beRunModuleFunction($userproduct["upmodule"],"extend",[
                            "userproduct" => $userproduct,
                            "updata" => $updata
                        ]);
                        if(!$response["status"]){
                            UserProductModel::beUpdate(["upprocess" => "0"])->beWhere("upid",$userproduct["upid"])->beExecute();
                            return ["status" => false,"message" => $response["message"]];
                        }
                    }   
                }
                $cart = new CartController();
                $invoice = new InvoiceController();
                $iid = InvoiceModel::beInsert([
                    "cid" => $userproduct["cid"],
                    "uid" => $userproduct["uid"],
                    "iname" => $userproduct["upname"]." ".beGetLang("invoice_order_extend_name"),
                    "idescription" => beGetLang("invoice_order_extend_name"),
                    "itype" => "2",
                    "istatus" => "0",
                    "ibill" => "0",
                    "iprice" => 0,
                    "itaxprice" => 0,
                    "idiscount" => 0,
                    "ifee" => 0,
                    "idata" => "",
                    "iexpiredate" => BE_TIME > $userproduct["upetime"] ? (BE_TIME+86400*3):($userproduct["upetime"]+432000),
                    "idateline" => BE_TIME 
                ]);
                if($userproduct["uptag"]){
                    $userproduct["uptag"] = "(".$userproduct["uptag"].")";
                }
                InvoiceItemModel::beInsert([
                    "iid" => $iid,
                    "cid" => $userproduct["cid"],
                    "iiobject" => "ExtendOrder",
                    "iiobjectid" => $userproduct["upid"],
                    "iiname" => $product["pname"].$userproduct["uptag"],
                    "iiunitprice" => $userproduct["upprice"],
                    "iiunitcount" => 1,
                    "iitaxrate" => $userproduct["uptaxrate"],
                    "iiunittype" => $upoptions["period"]["period"],
                    "iidata" => json_encode(["upid" => (int)$userproduct["upid"]]),
                    "iidateline" => BE_TIME
                ]);
                $extension = $cart->calculate_extension_nextprice($userproduct["upid"]);
                if($extension["status"]){
                    if($extension["basket"]){
                        foreach($extension["basket"] as $item){
                            InvoiceItemModel::beInsert([
                                "iid" => $iid,
                                "cid" => $item["cid"],
                                "iiobject" => "",
                                "iiobjectid" => 0,
                                "iiname" => $item["name"],
                                "iiunitprice" => $item["unitprice"],
                                "iiunitcount" => $item["unitcount"],
                                "iitaxrate" => $item["taxrate"],
                                "iiunittype" => $item["unittype"],
                                "iidata" => "",
                                "iidateline" => BE_TIME
                            ]);
                        }
                    }
                }
                $invoice->beCalculateInvoicePrices($iid);
                UserProductLogsModel::beInsert([
                    "uid" => $admin_uid ? $admin_uid:$userproduct["uid"],
                    "upid" => $userproduct["upid"],
                    "upltype" => "invoice_extend",
                    "upldata" => json_encode([
                        "iid" => $iid
                    ]),
                    "uplipaddress" => beRouter::$beUserIP,
                    "upldateline" => BE_TIME
                ]);
                UserLogModel::beInsert([
                    "uid" => $userproduct["uid"],
                    "ltype" => "invoice_extend",
                    "lipaddress" => beRouter::$beUserIP,
                    "ldata" => json_encode([
                        "uid" => $admin_uid ? (int)$admin_uid:$userproduct["uid"],
                        "iid" => $iid,
                        "upid" => (int)$userproduct["upid"]
                    ],JSON_UNESCAPED_UNICODE),
                    "ldateline" => BE_TIME
                ]);
                UserProductModel::beUpdate(["upprocess" => "0"])->beWhere("upid",$userproduct["upid"])->beExecute();
                return ["status" => true,"message" => beGetLang("invoice_created"),"iid" => $iid];
                break;
        }
    }
    //@ioncube.dk beEncrypt("be_diyocp","searchorderlogs_post") -> "ff5ea0b520e73453e1f38ca48d05bdee" RANDOM
    public function searchorderlogs_post(){
        $user = Auth::beGetUser();
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $upid = (int)$_POST["upid"];
        $uid = (int)$_POST["uid"];
        $pageitems = (int)$_POST["pageitems"];
        if(!$pageitems){
            $pageitems = 20;
        }
        $itemsearch = UserProductLogsModel::beSelect("COUNT(uplid) as total");
        if($upid){
            $itemsearch = $itemsearch->beWhere("upid",$upid);
        }
        if($uid){
            $itemsearch = $itemsearch->beWhere("uid",$uid);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"",$pageitems);
        $items = UserProductLogsModel::beSelect("be_user_product_logs.*,up.upname,up.uptag");
        if($upid){
            $items = $items->beWhere("be_user_product_logs.upid",$upid);
        }
        if($uid){
            $items = $items->beWhere("be_user_product_logs.uid",$uid);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        switch($sort){
            case 1 :
                $items = $items->beOrder("uplid","DESC");
                break;
            case 2 :
                $items = $items->beOrder("uplid","ASC");
                break;
        }
        $items = $items->beJoin("INNER JOIN be_user_products as up ON up.upid = be_user_product_logs.upid")->beGetAll();
        $logtypes = [
            "order_buy" => [
                "message" => '{price} {{ $currencies[{cid}]["cicon"] }} ödenerek <a href="{{ beGetRoute("admin.product.show",["pid" => {pid}]) }}" target="_blank">{{ $products[{pid}] }}</a> adlı ürün satın alındı!',
                "veriables" => ["pid","price","cid"]
            ],
            "transfer" => [
                "message" => 'Sipariş <a href="{{ beGetRoute("admin.user.show",["uid" => {old_uid}]) }}" target="_blank">#{old_uid}</a> adlı kullanıcıdan <a href="{{ beGetRoute("admin.user.show",["uid" => {new_uid}]) }}" target="_blank">#{new_uid}</a> adlı kullanıcıya taşındı!',
                "veriables" => ["old_uid","new_uid"]
            ],
            "invoice_extend" => [
                "message" => '<a href="{{ beGetRoute("admin.invoice.show",["iid" => {iid}]) }}" target="_blank">#{iid}</a> sayılı fatura kullanıcı tarafından ödendi!',
                "veriables" => ["iid"]
            ]
        ];
        $itemshtml = beGetView("admin.order.logs-listrows",["items" => $items,"logtypes" => $logtypes]);
        $currencies = CurrencyModel::beGetCurrencies("cid,cicon");
        $productlist = ProductModel::beSelect("be_products.pid,pt.pname")->beWhere("pt.lid",$user["lid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGetAll();
        $products = [];
        foreach($productlist as $product){
            $products[$product["pid"]] = $product["pname"];
        }
        $itemshtml = beViewer::beGetViewRaw($itemshtml,["products" => $products,"currencies" => $currencies]);
        return beAjaxSuccess(["html" => $itemshtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","orderfind_post") -> "66c46b60b8021bedce1f1f716fa534fa" RANDOM
    public function orderfind_post(){
        $ordername = $_POST["term"];
        if($ordername){
            $orderlistname = UserProductModel::beSelect("upid,concat(upname,'  #  ',uptag) as ordername")->beWhere("upname",$ordername,"LIKE")->beGetAll();
            $orderlisttag = UserProductModel::beSelect("upid,concat(upname,'  #  ',uptag) as ordername")->beWhere("uptag",$ordername,"LIKE")->beGetAll();
            $orderlist = array_merge($orderlistname,$orderlisttag);
            return json_encode($orderlist,JSON_UNESCAPED_UNICODE);
        }
        return json_encode([],JSON_UNESCAPED_UNICODE);
    }
    //@ioncube.dk beEncrypt("be_diyocp","delete_post") -> "f2e13f17daf43cb049e56f8ccb4e3d39" RANDOM
    public function delete_post(){
        beLanguage::beReadLang("order");
        $upid = (int)$_POST["upid"];
        $order = UserProductModel::beSelect("upid")->beWhere("upid",$upid)->beGet();
        if(!$order){
            return beAjaxError(["message" => beGetLang("order_not_found")]);
        }
        UserProductModel::beDelete()->beWhere("upid",$order["upid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("order_deleted")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","search_post") -> "86c60ec2ca926334438a4ae77fc2cdaa" RANDOM
    public function search_post(){
        $pageitems = (int)$_POST["pageitems"];
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $status = (int)$_POST["status"];
        $product = (int)$_POST["product"];
        $username = $_POST["username"];
        $userids = [];
        $data = $_POST["data"];
        $options = (int)$_POST["options"];
        if($username){
            $userdata = explode(" ",$username);
            $namecount = count($userdata);
            switch($namecount){
                case 1 :
                    $userlist = AuthModel::beSelect("uid")->beWhere("name",$userdata[0],"LIKE")->beGetAll();
                    if(!$userlist){
                        $userlist = AuthModel::beSelect("uid")->beWhere("surname",$userdata[0],"LIKE")->beGetAll();
                    }
                    if(!$userlist){
                        $userlist = AuthModel::beSelect("uid")->beWhere("email",$userdata[0],"LIKE")->beGetAll();
                    }
                    break;
                case 2 :
                    $userlist = AuthModel::beSelect("uid")->beWhere("name",$userdata[0],"LIKE")->beWhere("surname",$userdata[1],"LIKE")->beGetAll();
                    break;
                case 3 :
                    $userlist = AuthModel::beSelect("uid")->beWhere("name",$userdata[0]." ".$userdata[1],"LIKE")->beWhere("surname",$userdata[2],"LIKE")->beGetAll();
                    break;
            }
        }
        if($userlist){
            foreach($userlist as $user){
                $userids[] = (int)$user["uid"];
            }
        }
        $uid = (int)$_POST["user"];
        if($uid){
            $userids[] = $uid;
        }
        $ordersearch = UserProductModel::beSelect("COUNT(upid) as total");
        if($status > -2 && $status < 3){
            $ordersearch = $ordersearch->beWhere("upstatus",$status);
        }
        if($product){
            $ordersearch = $ordersearch->beWhere("pid",$product);
        }
        if($userids){
            $ordersearch = $ordersearch->beWhere("uid",$userids,"IN");
        }
        if($data){
            $ordersearch->beWhereGroup(function($query) use ($data){
                $query->beWhere("updata",$data,"LIKE");
                $query->beWhere("uptag",$data,"LIKE");
            });
        }
        $ordercount = (int)$ordersearch->beGet()["total"];
        $paganation = bePaganation($page,$ordercount,"",$pageitems);
        $orders = UserProductModel::beTable("be_user_products as up")->beSelect("upid,up.cid,up.upname,up.uptag,pid,upstatus,upprice,upstime,upntime,upetime,u.uid,u.name,u.surname");
        if($status > -2 && $status < 3){
            $orders = $orders->beWhere("upstatus",$status);
        }
        if($product){
            $orders = $orders->beWhere("pid",$product);
        }
        if($userids){
            $orders = $orders->beWhere("up.uid",$userids,"IN");
        }
        if($data){
            $orders->beWhereGroup(function($query) use ($data){
                $query->beWhere("updata",$data,"LIKE");
                $query->beWhere("uptag",$data,"LIKE");
            });
        }
        if($paganation["itemstart"] == 0){
            $orders = $orders->beLimit($paganation["itemlimit"]);
        }
        else{
            $orders = $orders->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "upid";
        switch($options){
            case 1 : 
                $orderkey = "upetime";
                break;
            case 2 :
                $orderkey = "upprice";
                break;
        }
        switch($sort){
            case 1 :
                $orders = $orders->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $orders = $orders->beOrder($orderkey,"ASC");
                break;
        }
        $orders = $orders->beJoin("INNER JOIN be_users as u ON u.uid = up.uid")->beGetAll();
        $cart = new CartController();
        foreach($orders as $key => $order){
            $extension = $cart->calculate_extension_nextprice($order["upid"]);
            if($extension["status"]){
                $orders[$key]["upprice"] += $extension["price"];
            }
        }
        $status = UserProductModel::beGetUserProductStatus();
        $currencies = CurrencyModel::beGetCurrencies("cid,cicon");
        $orderhtml = beGetView("admin.order.listrows",["orders" => $orders,"status" => $status,"currencies" => $currencies]);
        return beAjaxSuccess(["html" => $orderhtml,"paganation" => $paganation["paganation"],"ordercount" => $ordercount]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","beSetOrderMessages") -> "35daea525040660d132ae69b3bbc6d0c" RANDOM
    public function beSetOrderMessages($lid,&$userproductlogs){
        beLanguage::beReadLang("order");
        $productlist = ProductTranslationsModel::beSelect("pid,pname")->beWhere("lid",$lid)->beGetAll();
        $products = [];
        foreach($productlist as $product){
            $products[(int)$product["pid"]] = $product;
        }
        $currencies = CurrencyModel::beGetCurrencies("cid,cname,cicon");
        foreach($userproductlogs as $key => $userproductlog){
            $upldata = json_decode($userproductlog["upldata"],true);
            switch($userproductlog["upltype"]){
                case "order_buy" :
                    $userproductlogs[$key]["uplmessage"] = beGetLang("order_message_buy",["name" => $products[$upldata["upid"]]["pname"],"price" => $upldata["price"],"icon" => $currencies[$upldata["cid"]]["cicon"]]);
                    break;
                case "name_edit" :
                    $userproductlogs[$key]["uplmessage"] = beGetLang("order_message_name_edit",["old_name" => $upldata["old_name"],"new_name" => $upldata["new_name"],"old_tag" => $upldata["old_tag"],"new_tag" => $upldata["new_tag"]]);
                    break;
                case "note_edit" :
                    $userproductlogs[$key]["uplmessage"] = beGetLang("order_message_note_edit");
                    break;
                case "price_edit" :
                    $userproductlogs[$key]["uplmessage"] = beGetLang("order_message_price_edit",[
                        "price_icon" => $currencies[$upldata["cid"]]["cicon"],
                        "old_price" => $upldata["old_price"],
                        "new_price" => $upldata["new_price"],
                        "old_rate" => $upldata["old_rate"],
                        "new_rate" => $upldata["new_rate"],
                        "new_calcprice" => $upldata["new_calcprice"] == "product" ? "Ürün üzerinden":"Sipariş Üzerinden"
                    ]);
                    break;
                case "option_edit" :
                    $userproductlogs[$key]["uplmessage"] = beGetLang("order_message_option_edit");
                    break;
                case "invoice_extend" :
                    $userproductlogs[$key]["uplmessage"] = beGetLang("order_message_invoice_extend",["invoice_url" => beGetRoute("admin.invoice.show",["iid" => $upldata["iid"]]),"iid" => $upldata["iid"]]);
                    break;
                case "order_extend" :
                    $userproductlogs[$key]["uplmessage"] = beGetLang("order_message_order_extend",["extratime" => beConvertTime($upldata["extratime"]),"totaltime" => beSpecialTime($upldata["totaltime"])]);
                    break;
                case "transfer" :
                    $user1 = Auth::beGetUser($upldata["old_uid"],"uid,name,surname");
                    $user2 = Auth::beGetUser($upldata["new_uid"],"uid,name,surname");
                    $userproductlogs[$key]["uplmessage"] = beGetLang("order_message_transfer",[
                        "old_user_url" => beGetRoute("admin.user.show",["uid" => $user1["uid"]]),
                        "old_user_name_surname" => $user1["name"]." ".$user1["surname"],
                        "new_user_url" => beGetRoute("admin.user.show",["uid" => $user2["uid"]]),
                        "new_user_name_surname" => $user2["name"]." ".$user2["surname"],
                    ]);
                    break;
            }
        }
    }
}

?>