<?php

namespace App\System\Controller;

use App\System\Basic\beCache;
use App\System\Basic\beContoller;
use App\System\Model\SettingModel;
use App\System\Model\ThemeModel;
use App\System\Model\ThemePageModel;
use App\System\Vendor\beLanguage;

class ThemeController extends beContoller {
    public function list(){
        beLanguage::beReadLang("theme");
        global $be;
        $themecode = $be->settings["system_themename"];
        $themes = ThemeModel::beGetAll();
        return beGetView("admin.theme.list",["themes" => $themes,"themecode" => $themecode]);
    }
    public function select_post(){
        beLanguage::beReadLang("theme");
        $tid = (int)$_POST["tid"];
        $theme = ThemeModel::beSelect("tid,tcode")->beWhere("tid",$tid)->beGet();
        if(!$theme){
            return beAjaxError(["message" => beGetLang("theme_not_found")]);
        }
        SettingModel::beUpdate(["svalue" => $theme["tcode"]])->beWhere("scode","system_themename")->beExecute();
        $cache = new beCache;
        $cache->beClearCache();
        return beAjaxSuccess(["message" => beGetLang("theme_selected")]);
    }
    public function page_list(){
        $themepages = ThemePageModel::beSelect("tpid,tid,tpname,tpdateline")->beGetAll();
        $themelist = ThemeModel::beSelect("tid,tname")->beGetAll();
        $themes = [];
        foreach($themelist as $theme){
            $themes[(int)$theme["tid"]] = $theme["tname"];
        }
        return beGetView("admin.theme.page.list",["themepages" => $themepages,"themes" => $themes]);
    }
    public function page_add(){
        beLanguage::beReadLang("theme");
        $themelist = ThemeModel::beSelect("tid,tname")->beGetAll();
        $themes = [];
        foreach($themelist as $theme){
            $themes[(int)$theme["tid"]] = $theme["tname"];
        }
        return beGetView("admin.theme.page.add",["themes" => $themes]);
    }
    public function pageadd_post(){
        beLanguage::beReadLang("theme");
        beLanguage::beReadLang("form");
        $tid = (int)$_POST["tid"];
        $theme = ThemeModel::beSelect("tid")->beWhere("tid",$tid)->beGet();
        if(!$theme){
            return beAjaxError(["message" => beGetLang("theme_not_found")]);
        }
        $tpname = $_POST["tpname"];
        $tpheader = $_POST["tpheader"];
        $tpcontentup = $_POST["tpcontentup"];
        $tpcontent = $_POST["tpcontent"];
        $tpjavascript = $_POST["tpjavascript"];
        $tppagedata = $_POST["tppagedata"];
        if(!$tpname){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        $tpid = ThemePageModel::beInsert([
            "tid" => $theme["tid"],
            "tpname" => $tpname,
            "tpheader" => $tpheader,
            "tpcontentup" => $tpcontentup,
            "tpcontent" => $tpcontent,
            "tpjavascript" => $tpjavascript,
            "tppagedata" => $tppagedata,
            "tpdateline" => BE_TIME
        ]);
        return beAjaxSuccess(["message" => beGetLang("themepage_created"),"url" => beGetRoute("admin.theme.page.edit",["tpid" => $tpid])]);
    }
    public function page_edit($tpid){
        beLanguage::beReadLang("theme");
        $themepage = ThemePageModel::beWhere("tpid",$tpid)->beGet();
        if(!$themepage){
            beError(beGetLang("theme"),beGetLang("themepage_not_found"));
        }
        $themelist = ThemeModel::beSelect("tid,tname")->beGetAll();
        $themes = [];
        foreach($themelist as $theme){
            $themes[(int)$theme["tid"]] = $theme["tname"];
        }
        return beGetView("admin.theme.page.edit",["themepage" => $themepage,"themes" => $themes]);
    }
    public function pageedit_post(){
        beLanguage::beReadLang("theme");
        beLanguage::beReadLang("form");
        $tpid = (int)$_POST["tpid"];
        $themepage = ThemePageModel::beSelect("tpid")->beWhere("tpid",$tpid)->beGet();
        if(!$themepage){
            return beAjaxError(["message" => beGetLang("themepage_not_found")]);
        }
        $tid = (int)$_POST["tid"];
        $theme = ThemeModel::beSelect("tid")->beWhere("tid",$tid)->beGet();
        if(!$theme){
            return beAjaxError(["message" => beGetLang("theme_not_found")]);
        }
        $tpname = $_POST["tpname"];
        $tpheader = $_POST["tpheader"];
        $tpcontentup = $_POST["tpcontentup"];
        $tpcontent = $_POST["tpcontent"];
        $tpjavascript = $_POST["tpjavascript"];
        $tppagedata = $_POST["tppagedata"];
        if(!$tpname){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        ThemePageModel::beUpdate([
            "tid" => $theme["tid"],
            "tpname" => $tpname,
            "tpheader" => $tpheader,
            "tpcontentup" => $tpcontentup,
            "tpcontent" => $tpcontent,
            "tpjavascript" => $tpjavascript,
            "tppagedata" => $tppagedata
        ])->beWhere("tpid",$themepage["tpid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("themepage_updated")]);
    }
    public function pagedelete_post(){
        beLanguage::beReadLang("theme");
        $tpid = (int)$_POST["tpid"];
        $themepage = ThemePageModel::beSelect("tpid")->beWhere("tpid",$tpid)->beGet();
        if(!$themepage){
            return beAjaxError(["message" => beGetLang("themepage_not_found")]);
        }
        ThemePageModel::beDelete()->beWhere("tpid",$themepage["tpid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("themepage_deleted")]);
    }
}

?>