<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Basic\beModel;
use App\System\Model\AlertModel;
use App\System\Model\CurrencyModel;
use App\System\Model\UserLogModel;
use App\System\Model\UserProductModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;

class ClientLogController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","sms") -> "787a2607c95145bfc6c878c7af8e2d47" RANDOM
    public function sms(){
        beLanguage::beReadLang("clientarea");
        beLanguage::beReadLang("userlogs");
        NavController::beAddBreadcumb(beGetLang("clientarea"),beGetRoute("client.dashboard.alternative"));
        NavController::beAddBreadcumb(beGetLang("clientarea_nav_log_sms"));
        $user = Auth::beGetUser();
        $page = (int)$_GET["page"];
        if(!$page){
            $page = 1;
        }
        $itemcount = beModel::beTable("be_sms")->beSelect("COUNT(sid) as total")->beWhere("uid",$user["uid"])->beWhere("spriorty","1")->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,beGetRoute("client.log.email"),15,"user");
        $items = beModel::beTable("be_sms")->beSelect("sid,smessage,sdateline")->beWhere("uid",$user["uid"])->beWhere("spriorty","1");
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $items = $items->beOrder("sid","DESC")->beGetAll();
        beSetHeaderContent("",1);
        return beGetView("clientarea.logs.sms",["items" => $items,"itemcount" => $itemcount,"paganation" => $paganation]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","email") -> "274ab524c7b9ef17c84fd3c960ec79fd" RANDOM
    public function email(){
        beLanguage::beReadLang("clientarea");
        beLanguage::beReadLang("userlogs");
        NavController::beAddBreadcumb(beGetLang("clientarea"),beGetRoute("client.dashboard.alternative"));
        NavController::beAddBreadcumb(beGetLang("clientarea_nav_log_mail"));
        $user = Auth::beGetUser();
        $page = (int)$_GET["page"];
        if(!$page){
            $page = 1;
        }
        $itemcount = beModel::beTable("be_mail")->beSelect("COUNT(mid) as total")->beWhere("uid",$user["uid"])->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,beGetRoute("client.log.email"),15,"user");
        $items = beModel::beTable("be_mail")->beSelect("mid,msubject,mdateline")->beWhere("uid",$user["uid"]);
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $items = $items->beOrder("mid","DESC")->beGetAll();
        beSetHeaderContent("",1);
        return beGetView("clientarea.logs.mails",["items" => $items,"itemcount" => $itemcount,"paganation" => $paganation]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","alert") -> "a39c08b79c6fa7effef5927a913e2cdc" RANDOM
    public function alert(){
        beLanguage::beReadLang("clientarea");
        beLanguage::beReadLang("userlogs");
        NavController::beAddBreadcumb(beGetLang("clientarea"),beGetRoute("client.dashboard.alternative"));
        NavController::beAddBreadcumb(beGetLang("clientarea_nav_log_alert"));
        $user = Auth::beGetUser();
        $page = (int)$_GET["page"];
        if(!$page){
            $page = 1;
        }
        $itemcount = AlertModel::beSelect("COUNT(aid) as total")->beWhere("uid",$user["uid"])->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,beGetRoute("client.log.alert"),15,"user");
        $items = AlertModel::beTable("be_alerts as a")->beSelect("u.name,u.surname,a.*")->beWhere("a.uid",$user["uid"])->beJoin("INNER JOIN be_users as u ON u.uid = a.afuid");
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $items = $items->beOrder("aid","DESC")->beGetAll();
        beSetHeaderContent("",1);
        return beGetView("clientarea.logs.alerts",["items" => $items,"itemcount" => $itemcount,"paganation" => $paganation]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","user") -> "e9961ee257ac75a6881c7a11193bfa0d" RANDOM
    public function user(){
        beLanguage::beReadLang("clientarea");
        beLanguage::beReadLang("userlogs");
        NavController::beAddBreadcumb(beGetLang("clientarea"),beGetRoute("client.dashboard.alternative"));
        NavController::beAddBreadcumb(beGetLang("clientarea_nav_log_user"));
        $user = Auth::beGetUser();
        $page = (int)$_GET["page"];
        if(!$page){
            $page = 1;
        }
        $itemcount = UserLogModel::beSelect("COUNT(lid) as total")->beWhere("uid",$user["uid"])->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,beGetRoute("client.log.user"),15,"user");
        $items = UserLogModel::beWhere("uid",$user["uid"]);
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $items = $items->beOrder("lid","DESC")->beGetAll();
        beSetHeaderContent("",1);
        $usercontrolller = new UserController;
        $usercontrolller->beSetUserMessages($user["lid"],$items);
        return beGetView("clientarea.logs.users",["items" => $items,"itemcount" => $itemcount,"paganation" => $paganation]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","product") -> "73f80bb7278f45a3c4b677180f55722b" RANDOM
    public function product(){
        beLanguage::beReadLang("clientarea");
        beLanguage::beReadLang("userlogs");
        NavController::beAddBreadcumb(beGetLang("clientarea"),beGetRoute("client.dashboard.alternative"));
        NavController::beAddBreadcumb(beGetLang("clientarea_nav_log_userproduct"));
        $user = Auth::beGetUser();
        $page = (int)$_GET["page"];
        if(!$page){
            $page = 1;
        }
        $itemcount = UserProductModel::beSelect("COUNT(upid) as total")->beWhere("uid",$user["uid"])->beWhere("uid",$user["uid"])->beWhere("upstatus",-1)->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,beGetRoute("client.log.product"),15,"product");
        $items = UserProductModel::beWhere("uid",$user["uid"])->beWhere("upstatus",-1);
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $items = $items->beOrder("upid","DESC")->beGetAll();
        beSetHeaderContent("",1);
        $userproductstatus = UserProductModel::beGetUserProductStatus();
        $currencies = CurrencyModel::beGetCurrencies("cid,cname,cicon");
        return beGetView("clientarea.logs.product",["items" => $items,"userproductstatus" => $userproductstatus,"currencies" => $currencies,"itemcount" => $itemcount,"paganation" => $paganation]);
    }
}

?>