<?php

namespace App\System\Model;
use App\System\Basic\beModel;
use App\System\Controller\InvoiceController;

class InvoiceModel extends beModel {
    public $table = "be_invoices";
    public $primary_key = "iid";
    public static function beGetInvoiceStatus(){
        return [
            -1 => [
                0 => "İptal Edilmiş",
                1 => "danger"
            ],
            0 => [
                0 => "Beklemede",
                1 => "primary"
            ],
            1 => [
                0 => "Ödendi",
                1 => "success"
            ]
        ];
    }
    public static function beGetUnitTypes(){
        return [
            "none" => "Tek Seferlik",
            "quanity" => "Adet",
            "second" => "Saniye",
            "minute" => "Dakika",
            "hour" => "Saat",
            "day" => "Gün",
            "month" => "Ay",
            "year" => "Yıl",
        ];
    }
    public static function beGetInvoiceTypes(){
        return [
            1 => "Sipariş Faturası",
            2 => "Sipariş Uzatım Faturası",
            3 => "Özel Fatura",
            4 => "Bakiye Yükleme Faturası"
        ];
    }
    public static function beGetInvoiceBillStatus(){
        return [
            0 => [
                0 => "Fatura Kesilmedi",
                1 => "danger"
            ],
            1 => [
                0 => "Fatura Kesildi",
                1 => "success"
            ],
            2 => [
                0 => "Fatura Gönderildi",
                1 => "info"
            ]
        ];
    }
    public static function beCreateModuleInvoice($invoice = []){
        $invoicecontroller = new InvoiceController();
        $iid = InvoiceModel::beInsert([
            "cid" => $invoice["cid"],
            "uid" => $invoice["uid"],
            "iname" => $invoice["iname"],
            "idescription" => $invoice["idescription"],
            "itype" => "3",
            "istatus" => "0",
            "ibill" => "0",
            "iprice" => 0,
            "itaxprice" => 0,
            "idiscount" => 0,
            "ifee" => 0,
            "idata" => "",
            "iexpiredate" => $invoice["iexpiredate"] ? $invoice["iexpiredate"]:BE_TIME+86400,
            "idateline" => BE_TIME 
        ]);
        foreach($invoice["items"] as $item){
            InvoiceItemModel::beInsert([
                "iid" => $iid,
                "cid" => $invoice["cid"],
                "iiobject" => "Module",
                "iiobjectid" => $item["upid"],
                "iiname" => $item["name"],
                "iiunitprice" => $item["price"],
                "iiunitcount" => $item["count"],
                "iitaxrate" => $invoice["itaxrate"],
                "iiunittype" => "none",
                "iidata" => json_encode($item["data"],JSON_UNESCAPED_UNICODE),
                "iidateline" => BE_TIME
            ]);
        }
        $invoicecontroller->beCalculateInvoicePrices($iid);
        return $iid;
    }
}

?>