<?php

namespace App\System\Model;
use App\System\Basic\beModel;

class MessageTemplateModel extends beModel {
    public $table = "be_message_templates";
    public $primary_key = "pid";
    public static $messages = [];
    public static function beGetMessages($msgcodes,$lang = 1,$types = "mail,alert,sms",$select = "mt.mtid,mt.mtcategory,mt.mtcode,mtt.mtttype,mtt.mttsubject,mtt.mttmessage,mtt.mttstatus"){
        $msgcodes = explode(",",$msgcodes);
        $types = explode(",",$types);
        $messages = self::beTable("be_message_templates as mt")->beSelect($select);
        if($msgcodes){
            $messages = $messages->beWhere("mt.mtcode",$msgcodes,"IN");
        }
        if($lang){
            $messages = $messages->beWhere("mtt.lid",$lang);
        }
        $messagelist = $messages->beWhere("mtt.mttstatus",1)->beWhere("mtt.mtttype",$types,"IN")->beJoin("INNER JOIN be_message_templates_translations as mtt ON mtt.mtid = mt.mtid")->beGetAll();
        $messages = [];
        foreach($messagelist as $message){
            $messages[$message["mtcode"]][$message["mtttype"]] = $message;
            self::$messages[$message["mtcode"]][$message["mtttype"]] = $message;
        }
        return $messages;
    }
}

?>