<?php

namespace App\System\Model;
use App\System\Basic\beModel;

class ProductModel extends beModel {
    public $table = "be_products";
    public $primary_key = "pid";
    //@ioncube.dk beEncrypt("be_diyocp","beGetPeriods") -> "9db4678ee21097c9d08cbae3d9444aea" RANDOM
    public static function beGetPeriods(){
        return [
            "none" => "Tek Seferlik",
            "hour" => "Saatlik",
            "day" => "Günlük",
            "month" => "Aylık",
            "year" => "Yıllık"
        ];
    }
    //@ioncube.dk beEncrypt("be_diyocp","beGetPeriodsTimes") -> "4b449cfd46207f1b136e07fcd8f69866" RANDOM
    public static function beGetPeriodsTimes(){
        return [
            "none" => 0,
            "hour" => 3600,
            "day" => 86400,
            "month" => 2592000,
            "year" => 31104000
        ];
    }
    //@ioncube.dk beEncrypt("be_diyocp","beConvertPeriods") -> "6f935b40b54ea412e079d0036856d0ec" RANDOM
    public static function beConvertPeriods($fromperiod,$toperiod){
        $periods = self::beGetPeriodsTimes();
        return $periods[$fromperiod]/$periods[$toperiod];
    }
    //@ioncube.dk beEncrypt("be_diyocp","beGetProductServer") -> "786e63d3e9345e13258d19b2841be173" RANDOM
    public static function beGetProductServer($pid){
        $product = self::beSelect("pid,sid")->beWhere("pid",$pid)->beGet();
        if(!$product){
            return false;
        }
        $server = ServerModel::beGetServer($product["sid"]);
        return $server;
    }
}

?>