<?php

namespace App\System\Module;
use App\System\Basic\beRouter;
use App\System\Model\PaymentModel;
use App\System\Model\SettingModel;
use App\System\Model\UserInfoModel;
use App\System\Vendor\Auth;

class shopier {
    public function shopier_info(){
        return [
            "name" => "PayTR",
            "description" => "PayTR ile ödeme almanızı sağlar",
            "version" => "1.2",
            "vercode" => 12,
            "author" => "ITenGriTR",
        ];
    }
    public function shopier_is_activated(){
        $settings = SettingModel::beGetSettings("shopier_status");
        return $settings["shopier_status"] == 1 ? true:false;
    }
    public function shopier_currency(){
        return 1;
    }
    public function shopier_template($params = []){
        $settings = SettingModel::beGetSettings("shopier_methodfee");
        $price = $params["total"];
        $currency = $params["currency"];
        $newprice = $price*(100+$settings["shopier_methodfee"])/100;
        return beGetView("global.shopier",["price" => round($newprice,2),"currency" => $currency]);
    }
    public function shopier_pay_page($invoice){
        return ["status" => true,"template" => beGetView("global.shopierpay",["invoice" => $invoice])];
    }
    public function shopier_create_payment($invoice){
        $settings = SettingModel::beGetSettings("shopier_merchant_user,shopier_merchant_password,shopier_methodfee");
        $user = Auth::beGetUser();
        $price = $invoice["itotal"];
        $invoice["ifee"] = round($price*$settings["shopier_methodfee"]/100,2);
        $price = $price*(100+$settings["shopier_methodfee"])/100;
        $price = round($price,2);
        $userinfo = UserInfoModel::beSelect("uiphone,uiaddress")->beWhere("uid",$user["uid"])->beGet();
        if(!$user["adress"]){
            $user["adress"] = "Bilinmeyen adres bilgisi!";
        }
       $post_vals = [
            "API_key" => $settings["shopier_merchant_user"],
            "website_index" => 1,
            "platform_order_id" => $invoice["oid"],
            "product_name" => $invoice["iname"],
            "product_type" => 0,
            "buyer_name" => $user["name"],
            "buyer_surname" => $user["surname"],
            "buyer_email" => $user["email"],
            "buyer_account_age" => 0,
            "buyer_id_nr" => $user["uid"],
            "buyer_phone" => $userinfo["uiphone"],
            "billing_address" => $userinfo["uiaddress"],
            "billing_city" => $userinfo["uiaddress"],
            "billing_country" => "Türkiye",
            "billing_postcode" => "",
            "shipping_address" => "",
            "shipping_city" => "",
            "shipping_country" => "",
            "shipping_postcode" => "",
            "total_order_value" => $price,
            "currency" => 0,
            "platform" => 0,
            "is_in_frame" => 0,
            "current_language" => 0,
            "modul_version" => "1.0.4",
            "random_nr" => rand(100000,999999),
            "callback" => beGetRoute("client.dashboard")
        ];	
        $data = $post_vals["random_nr"].$post_vals["platform_order_id"].$post_vals["total_order_value"].$post_vals["currency"];
		$post_vals["signature"] = base64_encode(hash_hmac("sha256",$data,$settings["shopier_merchant_password"],true));
        $formdata = "<form id=\"returnform\" method=\"post\" action=\"https://www.shopier.com/ShowProduct/api_pay4.php\">";
        foreach($post_vals as $key => $val){
            $formdata.= "<input type=\"hidden\" name=\"{$key}\" value=\"{$val}\">";
        }
        $formdata .= "</form>";
        return [
            "status" => true,
            "invoice" => $invoice,
            "message" => "Başarılı bir şekilde ödeme işleminiz oluşturuldu!",
            "html" => $formdata
        ];
    }
    public function shopier_pay_callback(){
        if($_POST["status"] != "success"){
            beError("Ödeme Hatası","Ödeme işleminizde bir sorun oluştu ve başarısız sonuçlandı!");
        }
        $settings = SettingModel::beGetSettings("shopier_merchant_password");
        $oid = $_POST["platform_order_id"];
        $random_nr = $_POST["random_nr"];
        $signature = base64_decode($_POST["signature"]);
        $expected = hash_hmac("sha256",$random_nr.$oid,$settings["shopier_merchant_password"],true);
        if($signature != $expected){
            return ["status" => false,"message" => "Token doğrulamadı lütfen sistemi kontrol edin!"];
        }
        $payment = PaymentModel::beSelect("pid,cid,uid,iid,ptotal,pstatus")->beWhere("pid",$oid)->beGet();
        if(!$payment){
            return ["status" => false,"message" => "OK"];
        }
        if($payment["pstatus"] != 0){
            PaymentModel::beUpdate(["pstatus" => "-1"])->beWhere("pid",$payment["pid"])->beExecute();
            return ["status" => false,"message" => "OK"];
        }
        if($_POST["status"] != "success"){
            PaymentModel::beUpdate(["pstatus" => "-1"])->beWhere("pid",$payment["pid"])->beExecute();
            return ["status" => false,"message" => "OK"];
        }
        PaymentModel::beUpdate(["pstatus" => "1"])->beWhere("pid",$payment["pid"])->beExecute();
        return ["status" => true,"payment" => $payment,"add_accounting" => true,"message" => "OK","url" => beGetRoute("client.userproduct.userproducts")];
    }
}
?>