<?php

namespace App\System\Module;
use App\System\Controller\CartController;
use App\System\Model\AuthModel;
use App\System\Model\PaymentModel;
use App\System\Vendor\Auth;

class wallet {
    public function wallet_info(){
        return [
            "name" => "Bakiye",
            "description" => "Kullanıcı bakiyesi ile ödeme almanızı sağlar",
            "version" => "1.2",
            "vercode" => 12,
            "author" => "ITenGriTR",
        ];
    }
    public function wallet_is_activated(){
        global $be;
        return $be->settings["system_localmoney"] == 1 ? true:false;
    }
    public function wallet_currency(){
        return 1;
    }
    public function wallet_template($params = []){
        $price = $params["total"];
        $currency = $params["currency"];
        $user = Auth::beGetUser();
        $money = $user["money"];
        $class = "";
        if($money >= $price){
            $class = " text-success";
        }
        else{
            $class = " text-danger";
        }
        return beGetView("global.wallet",["price" => $price,"money" => $money,"class" => $class,"currency" => $currency]);
    }
    public function wallet_create_payment($invoice){
        $user = Auth::beGetUser();
        if($user["money"] < $invoice["itotal"]){
            return ["status" => false,"message" => "Bakiyeniz ödeme işlemi için yetersiz"];
        }
        $user["money"] -= $invoice["itotal"];
        AuthModel::beUpdate(["money" => $user["money"]])->beWhere("uid",$user["uid"])->beExecute();
        $cart = new CartController(); 
        $invoice = $cart->cart_invoice_approve($invoice["iid"]);
        if($invoice["error"]){
            return ["status" => false,"message" => $invoice["error"]];
        }
        PaymentModel::beUpdate(["pstatus" => "1"])->beWhere("pid",$invoice["oid"])->beExecute();
        return [
            "status" => true,
            "message" => "Ödeme işleminiz tamamlandı",
            "url" => beGetRoute("client.userproduct.userproducts")
        ];
    }
}
?>