<?php

namespace App\System\Module;

use App\System\Basic\beModel;
use App\System\Controller\ConnectionController;
use App\System\Controller\NavController;
use App\System\Model\CurrencyModel;
use App\System\Model\ModuleLogModel;
use App\System\Model\ProductModel;
use App\System\Model\ServerModel;
use App\System\Model\UserInfoModel;
use App\System\Model\UserProductModel;
use App\System\Vendor\Auth;
use App\System\Vendor\Basic\beCookie;
use App\System\Vendor\beLanguage;
use App\System\Vendor\bePlugin;
use Exception;
use SoapClient;

class domainnameapi {
    public $pages = [
        "/" => [
            "showmenu" => true,
            "name" => "Ana Sayfa",
            "icon" => "<i class=\"ri-home-line\"></i>"
        ],
        "ad-sunucusu-yonetimi" => [
            "showmenu" => true,
            "name" => "Ad Sunucusu Yönetimi",
            "icon" => "<i class=\"ri-git-repository-private-line\"></i>",
            "function" => "domainnameapi_clientarea_nameserver"
        ],
        "genel-ayarlar" => [
            "showmenu" => true,
            "name" => "Ayarlar",
            "icon" => "<i class=\"ri-git-repository-private-line\"></i>",
            "function" => "domainnameapi_clientarea_settings"
        ],
        /*"ozel-ad-sunucusu-yonetimi" => [
            "showmenu" => true,
            "name" => "Özel Ad Sunucusu Yönetimi",
            "icon" => "<i class=\"ri-git-repository-private-line\"></i>",
            "function" => "domainnameapi_clientarea_nameserver_special"
        ],*/
        "iletisim-bilgileri" => [
            "showmenu" => true,
            "name" => "İletişim Bilgieri",
            "icon" => "<i class=\"ri-git-repository-private-line\"></i>",
            "function" => "domainnameapi_clientarea_contact"
        ]
    ];
    public $dnaclient = null;
    public function domainnameapi_info(){
        return [
            "name" => "Domain Name API Modülü",
            "description" => "Bu alan adi sistemi Domain Name API adreslerini kullanarak çalışır.",
            "version" => "1.0",
            "vercode" => 10,
            "type" => "domain",
            "status" => 1,
            "author" => "ITenGriTR"
        ];
    }
    public function domainnameapi_connection_test($params = []){
        return ["status" => true];
    }
    public function domainnameapi_order_config(){
        return [
            "domain" => [
                "name" => "Alan Adı",
                "description" => "Kullanıcının yöneteceği temel alan adı",
                "type" => "string",
                "default" => ""
            ],
            "nameserver1" => [
                "name" => "NameServer 1",
                "description" => "Alan adının NameServer 1 adresi",
                "type" => "string",
                "default" => ""
            ],
            "nameserver2" => [
                "name" => "NameServer 2",
                "description" => "Alan adının NameServer 2 adresi",
                "type" => "string",
                "default" => ""
            ]
        ];
    }
    public function domainnameapi_product_config($params = []){
        return [
            "nameserver_1" => [
                "name" => "NS1 Adresini Belirleyiniz",
                "description" => "Alan adı satın alındığında otomatik olarak atanacak olan NS1 adresini giriniz",
                "type" => "string",
                "default" => "",
                "form-view" => [
                    "class" => "col-6" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "nameserver_2" => [
                "name" => "NS2 Adresini Belirleyiniz",
                "description" => "Alan adı satın alındığında otomatik olarak atanacak olan NS2 adresini giriniz",
                "type" => "string",
                "default" => "",
                "form-view" => [
                    "class" => "col-6" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ]
        ];
    }
    public function domainnameapi_addon_config($params = []){
        return [        
            "domain_extension" => [
                "name" => "Alan Adı Uzantısı",
                "description" => "Alan adının uzantısını giriniz örnek(.com)",
                "type" => "string",
                "default" => "",
                "form-view" => [
                    "class" => "col-12" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ]
        ];
    }
    public function domainnameapi_preaddcart($params){
        $extension = "";
        $name = "";
        foreach($params["addonoptions"] as $addonoption){
            if($addonoption[5] == "domain_extension"){
                $extension = $addonoption[1];
            }
            if($addonoption[5] == "domain_name"){
                $name = $addonoption[1];
            }
            if($extension && $name){
                break;
            }
        }
        if(strpos($name,".") !== false){
            $name = explode(".",$name)[0];
        }
        $this->beConnectClient($params["server"]["surl"]);
        $response = $this->dnaclient->CheckAvailability([
            "request" => [
                "UserName"       => $params["server"]["susername"],
                "Password"       => $params["server"]["spassword"],
                "DomainNameList" => [$name],
                "TldList"        => [substr($extension,1)],
                "Period"         => "1",
                "Commad"         => "create"
            ]
        ]);
        $this->beObjectToArray($response);
        $data = $response[key($response)];
        if($data["ErrorCode"] != 0){
            echo beAjaxError(["message" => "Alan adı sisteminde bir sorun oluştu lütfen destek talebi oluşturunuz!"]);
            exit;
        }
        if($data["DomainAvailabilityInfoList"]["DomainAvailabilityInfo"][0]["Status"] == "notavailable"){
            echo beAjaxError(["message" => "Belirtilen alan adı dolu gözüküyor lütfen başka eşsiz bir alan adı giriniz!"]);
            exit;
        }
        return ["status" => true];
    }
    public function domainnameapi_tldlist($itemcount){
        $server = ServerModel::beGetServer("domainnameapi");
        if(!$server){
            return ["status" => false,"message" => "Alan adı uzantıları için DomainNameAPI modülünün sunucu bilgileri girilmemiş."];
        }
        $this->beConnectClient($server["surl"]);
        $response = $this->dnaclient->GetTldList([
            "request" => [
                "UserName" => $server["susername"],
                "Password" => $server["spassword"],
                "IncludePriceDefinitions" => 1,
                "PageSize" => $itemcount
            ]
        ]);
        $this->beObjectToArray($response);
        $response = $response["GetTldListResult"];
        if(!isset($response["TldInfoList"]) || !is_array($response["TldInfoList"])){
            return ["status" => false,"message" => "Alan adı uzantıları çekilirken bir sorun oluştu!","response" => $response];
        }
        $extensions = [];
        foreach($response["TldInfoList"]["TldInfo"] as $key => $value){
            $prices = [];
            foreach($value["PriceInfoList"]["TldPriceInfo"] as $price){
                if($price["CurrencyId"] != 2){
                    continue;
                }
                $prices[$price["TradeType"]] = $price["Price"];
            }
            $extensions[$value["Name"]] = [
                "extension" => $value["Name"],
                "prices" => $prices
            ];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde alan adı uzantıları çekildi","extensions" => $extensions];
    }
    public function domainnameapi_checkdomain($domains = []){
        $domainnames = [];
        $domainextensions = [];
        foreach($domains as $domain){
            $domainname = explode(".",$domain)[0];
            if(!in_array($domainname,$domainnames)){
                $domainnames[] = $domainname;
            }
            $extension = str_replace($domainname.".","",$domain);
            if(!in_array($extension,$domainextensions)){
                $domainextensions[] = $extension;
            }
        }
        $server = ServerModel::beGetServer("domainnameapi");
        $this->beConnectClient($server["surl"]);
        $response = $this->dnaclient->CheckAvailability([
            "request" => [
                "UserName" => $server["susername"],
                "Password" => $server["spassword"],
                "DomainNameList" => $domainnames,
                "TldList" => $domainextensions,
                "Period" => "1",
                "Commad" => "create"
            ]
        ]);
        $this->beObjectToArray($response);
        $data = $response[key($response)];
        $availabledomains = [];
        if(isset($data["DomainAvailabilityInfoList"]["DomainAvailabilityInfo"]["Tld"])){
            $buffer = $data["DomainAvailabilityInfoList"]["DomainAvailabilityInfo"];
            $data = ["DomainAvailabilityInfoList" => ["DomainAvailabilityInfo" => [$buffer]]];
        }
        foreach($data["DomainAvailabilityInfoList"]["DomainAvailabilityInfo"] as $domain){
            if($domain["Currency"] == "TL"){
                $domain["Currency"] = "TRY";
            }
            $availabledomains[] = [
                "name" => $domain["DomainName"],
                "extension"  => ".".$domain["Tld"],
                "available" => $domain["Status"] == "available" ? true:false,
                "price" => $domain["Price"],
                "currency" => $domain["Currency"],
                "Reason" => $domain["Reason"],
            ];
        }
        return ["status" => true,"domains" => $availabledomains];
    }
    public function domainnameapi_create($params = []){
        $userproduct = $params["userproduct"];
        $user = Auth::beGetUser($userproduct["uid"],"uid,name,surname,email");
        $upoptions = json_decode($userproduct["upoptions"],true);
        $domainname = "";
        foreach($upoptions as $option => $data){
            if($data["code"] == "domain_name"){
                $domainname = $data["key"];
                break;
            }
        }
        $extension = $params["addonmodules"]["domain_extension"][0];
        $domain = $domainname.$extension;
        if(empty($params["server"]["snameserver1"]) || empty($params["server"]["snameserver2"])){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"domainnameapi","Kurulum Hatası","Alan adı sisteminde bir sorun oluştu hata: NameServer sunucuları boş olarak girilemez!",[
                "data" => [],
                "response" => []
            ]);
            return ["status" => false,"message" => "Alan adı sisteminde bir sıkıntı çıktı lütfen destek talebi oluşturun!"];
        }
        $userinfo = UserInfoModel::beWhere("uid",$user["uid"])->beGet();
        if(!$userinfo){
            return ["status" => false,"message" => "Lütfen tüm iletişim ve adres bilgileriniz doğru olduğundan emin olun!"];
        }
        $country = beModel::beTable("be_address_country")->beSelect("acid,acname")->beWhere("acid",$userinfo["acid"])->beGet();
        $usercontactdata = [
            "FirstName"  => mb_convert_encoding($user["name"],"UTF-8","auto"),
            "LastName"  => mb_convert_encoding($user["surname"],"UTF-8","auto"),
            "Company"  => mb_convert_encoding($user["name"]." ".$user["surname"],"UTF-8","auto"),
            "EMail" => $user["email"],
            "AddressLine1" => $userinfo["uiaddress"],
            "AddressLine2" => $userinfo["uiaddress"],
            "State" => mb_convert_encoding($userinfo["uiprovince"],"UTF-8","auto"),
            "City" => mb_convert_encoding($userinfo["uidistrict"],"UTF-8","auto"),
            "Country" => "TR",
            "Phone" => $userinfo["uiphone"],
            "PhoneCountryCode" => $userinfo["uidial"],
            "Type" => "Contact",
            "ZipCode" => $userinfo["uiphone"]
        ];
        $request = [
            "UserName" => $params["server"]["susername"],
            "Password" => $params["server"]["spassword"],
            "DomainName" => $domain,
            "Period" => "1",
            "NameServerList" => [$params["server"]["snameserver1"],$params["server"]["snameserver2"]],
            "LockStatus" => true,
            "PrivacyProtectionStatus" => true,
            "AdministrativeContact" => $usercontactdata,
            "BillingContact" => $usercontactdata,
            "TechnicalContact" => $usercontactdata,
            "RegistrantContact" => $usercontactdata
        ];
        if($extension == ".com.tr"){
            $useridentityplugin = bePlugin::beGetPlugin("useridentity");
            if(!$useridentityplugin["status"]){
                ModuleLogModel::beCreateModuleLog($userproduct["upid"],"domainnameapi","Kurulum Hatası","Alan adı sisteminde .com.tr domainin kullanılabilmesi için kimlik eklentisinin aktif olması gerekmektedir.");
                return ["status" => false,"message" => "Alan adı sisteminde bir sıkıntı çıktı lütfen destek talebi oluşturun!"];
            }
            $useridentity = beModel::beTable("be_user_identity")->beWhere("uid",$user["uid"])->beGet();
            $distric = beModel::beTable("be_address_district")->beSelect("adid,adname,adcode")->beWhere("adid",$useridentity["adid"])->beGet();
            switch($useridentity["uitype"]){
                case 1 :
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISDOMAINCATEGORY","Value" => 1];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISCITIZIENID","Value" => $useridentity["uitcno"]];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISNAMESURNAME","Value" => $useridentity["uiname"]." ".$useridentity["uisurname"]];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISCOUNTRYID","Value" => 215];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISCOUNTRYNAME","Value" => "Türkiye"];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISCITYID","Value" => $distric["adcode"]];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISCITYNAME","Value" => $distric["adname"]];
                    break;
                case 2 :
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISDOMAINCATEGORY","Value" => 0];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISORGANIZATION","Value" => $useridentity["uititle"]];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISTAXOFFICE","Value" => $useridentity["uitaxadmin"]];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISTAXNUMBER","Value" => $useridentity["uitaxno"]];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISCOUNTRYID","Value" => 215];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISCOUNTRYNAME","Value" => "Türkiye"];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISCITYID","Value" => $distric["adcode"]];
                    $request["AdditionalAttributes"]["KeyValueOfstringstring"][] = ["Key" => "TRABISCITYNAME","Value" => $distric["adname"]];
                    break;
            }
        }
        $this->beConnectClient($params["server"]["surl"]);
        $response = $this->dnaclient->RegisterWithContactInfo([
            "request" => $request
        ]);
        $this->beObjectToArray($response);
        $data = $response[key($response)];
        if(!isset($data["DomainInfo"]) || !is_array($data["DomainInfo"])){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"domainnameapi","Kurulum Hatası","Alan adı sisteminde bir sorun oluştu hata:".$data["OperationMessage"],[
                "data" => [],
                "response" => $response
            ]);
            return ["status" => false,"message" => "Alan adı sisteminde bir sıkıntı çıktı lütfen destek talebi oluşturun!"];
        }
        $updatedata = [];
        $updatedata["uptag"] = $domain;
        $updata = [
            "domain" => $domain,
            "nameserver1" => $params["server"]["snameserver1"],
            "nameserver2" => $params["server"]["snameserver2"],
            "nameserver3" => "",
            "nameserver4" => "",
            "nameserver5" => "",
            "privacyprotection" => 1,
            "idprotection" => 1
        ];
        $updatedata["updata"] = json_encode($updata,JSON_UNESCAPED_UNICODE);
        UserProductModel::beUpdate($updatedata)->beWhere("upid",$userproduct["upid"])->beExecute();
        return ["status" => true,"message" => "Ürün yönetim paneline yönlendiliriliyorsunuz","url" => beGetRoute("client.userproduct.userproducts")];
    }
    public function domainnameapi_manage($params = []){
        $userproduct = $params["userproduct"];
        beCookie::beCreateCookie("be_upid",$userproduct["upid"],true,true);
        return ["status" => true,"message" => "Ürün yönetim paneline yönlendiliriliyorsunuz","url" => beGetRoute("client.userproduct.userproduct.show",["upid" => $userproduct["upid"]])];
    }
    public function domainnameapi_extended($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $server = ServerModel::beGetServer("domainnameapi");
        $this->beConnectClient($server["surl"]);
        $response = $this->dnaclient->Renew([
            "request" => [
                "UserName" => $server["susername"],
                "Password" => $server["spassword"],
                "DomainName" => $updata["domain"],
                "Period" => "1"
            ]
        ]);
        $this->beObjectToArray($response);
        $data = $response[key($response)];
        error_log($data);
        return ["status" => true];
    }
    public function domainnameapi_clientarea_nameserver($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        return beGetView("modules.domainnameapi.nameserver",["userproduct" => $userproduct,"updata" => $updata]); 
    }
    public function domainnameapi_nameserver($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $nameservers = [];
        for($i = 1; $i < 6; $i++){
            if(empty($_POST["nameserver".$i])){
                continue;
            }
            $nameservers[$i] = htmlspecialchars($_POST["nameserver".$i]);
        }
        if(empty($nameservers)){
            return beAjaxError(["message" => "Ad sunucusu ayarları boş olamaz lütfen tekrar kontorl edin!"]);
        }
        $this->beConnectClient($params["server"]["surl"]);
        $response = $this->dnaclient->ModifyNameServer([            
            "request" => [
                "UserName" => $params["server"]["susername"],
                "Password" => $params["server"]["spassword"],
                "DomainName" => $updata["domain"],
                "NameServerList" => array_values($nameservers)
            ]
        ]);
        $this->beObjectToArray($response);
        $data = $response[key($response)];
        if($data["ErrorCode"] != 100){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"domainnameapi","NS Güncelleme Hatası","Alan adı sisteminde bir sorun oluştu hata:".$data["OperationMessage"],[
                "data" => [],
                "response" => $data
            ]);
            return beAjaxError(["message" => "Ad sunucusu ayarları değiştirilemedi lütfen tekrar kontrol ediniz!"]);
        }
        foreach($nameservers as $key => $value){
            $updata["nameserver".$key] = $value;
        }
        $updatedata["updata"] = json_encode($updata,JSON_UNESCAPED_UNICODE);
        UserProductModel::beUpdate($updatedata)->beWhere("upid",$userproduct["upid"])->beExecute();
        return beAjaxSuccess(["message" => "Başarılı bir şekilde ad sunucusu ayarları güncellendi!"]);
    }
    public function domainnameapi_clientarea_settings($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        return beGetView("modules.domainnameapi.settings",["userproduct" => $userproduct,"updata" => $updata]); 
    }
    public function domainnameapi_settings($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $this->beConnectClient($params["server"]["surl"]);
        /*if($updata["privacyprotection"] != (int)$_POST["privacyprotection"]){
            $status = (int)$_POST["privacyprotection"] == 1 ? true:false;
            $response = $this->dnaclient->ModifyPrivacyProtectionStatus([
                "request" => [
                    "UserName" => $params["server"]["susername"],
                    "Password" => $params["server"]["spassword"],
                    "DomainName" => $updata["domain"],
                    "ProtectPrivacy" => $status,
                    "Reason" => "Owner request"
                ]
            ]);
            $updata["privacyprotection"] = (int)$_POST["privacyprotection"];
        }*/
        if($updata["idprotection"] != $_POST["idprotection"]){
            $status = (int)$_POST["idprotection"];
            if($status == 1){
                $this->dnaclient->EnableTheftProtectionLock([
                    "request" => [
                        "UserName" => $params["server"]["susername"],
                        "Password" => $params["server"]["spassword"],
                        "DomainName" => $updata["domain"]
                    ]
                ]);
            }
            else{
                $this->dnaclient->DisableTheftProtectionLock([
                    "request" => [
                        "UserName" => $params["server"]["susername"],
                        "Password" => $params["server"]["spassword"],
                        "DomainName" => $updata["domain"]
                    ]
                ]);
            }
            $updata["idprotection"] = $status;
        }
        $updatedata["updata"] = json_encode($updata,JSON_UNESCAPED_UNICODE);
        UserProductModel::beUpdate($updatedata)->beWhere("upid",$userproduct["upid"])->beExecute();
        return beAjaxSuccess(["message" => "Başarılı bir şekilde ad sunucusu ayarları güncellendi!"]);
    }
    public function domainnameapi_clientarea_contact($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $this->beConnectClient($params["server"]["surl"]);
        $response = $this->dnaclient->GetContacts([
            "request" => [
                "UserName" => $params["server"]["susername"],
                "Password" => $params["server"]["spassword"],
                "DomainName" => $updata["domain"],
            ]
        ]);
        $contact = json_decode(json_encode($response->GetContactsResult->BillingContact,JSON_UNESCAPED_UNICODE),true);
        return beGetView("modules.domainnameapi.contact",["userproduct" => $userproduct,"contact" => $contact]);
    }
    public function domainnameapi_contact($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $this->beConnectClient($params["server"]["surl"]);
        $response = $this->dnaclient->GetContacts([
            "request" => [
                "UserName" => $params["server"]["susername"],
                "Password" => $params["server"]["spassword"],
                "DomainName" => $updata["domain"],
            ]
        ]);
        $contact = json_decode(json_encode($response->GetContactsResult->BillingContact,JSON_UNESCAPED_UNICODE),true);
        $usercontactdata = [
            "FirstName"  => mb_convert_encoding($_POST["FirstName"],"UTF-8","auto"),
            "LastName"  => mb_convert_encoding($_POST["LastName"],"UTF-8","auto"),
            "Company"  => mb_convert_encoding($_POST["Company"],"UTF-8","auto"),
            "EMail" => $_POST["EMail"],
            "AddressLine1" => $_POST["AddressLine1"],
            "AddressLine2" => $_POST["AddressLine1"],
            "State" => mb_convert_encoding($_POST["State"],"UTF-8","auto"),
            "City" => mb_convert_encoding($_POST["City"],"UTF-8","auto"),
            "Country" => "TR",
            "Phone" => $_POST["Phone"],
            "PhoneCountryCode" => $contact["PhoneCountryCode"],
            "Type" => "Contact",
            "ZipCode" => $contact["ZipCode"]
        ];
        $response = $this->dnaclient->SaveContacts([
            "request" => [
                "UserName" => $params["server"]["susername"],
                "Password" => $params["server"]["spassword"],
                "DomainName" => $updata["domain"],
                "AdministrativeContact" => $usercontactdata,
                "BillingContact" => $usercontactdata,
                "TechnicalContact" => $usercontactdata,
                "RegistrantContact" => $usercontactdata
            ]
        ]);
        $this->beObjectToArray($response);
        $data = $response[key($response)];
        if($data["ErrorCode"] != 0){
            return beAjaxError(["message" => "Alan adı sisteminde bir sorun oluştu, lütfen tüm alanları kontrol edin!"]);
        }
        return beAjaxSuccess(["message" => "Başarılı bir şekilde iletişim bilgileri güncellendi!","refresh" => 1]);
    }
    public function domainnameapi_clientarea($params = []){
        beLanguage::beReadLang("domainnameapi");
        $userproduct = $params["userproduct"];
        $url = $params["url"];
        $page = $params["page"];
        $updata = json_decode($userproduct["updata"],true);
        $upoptions = json_decode($userproduct["upoptions"],true);
        if($page){
            $pageinfo = $this->pages[$page];
            if($pageinfo){
                $params["title"] = $pageinfo["name"];
                NavController::beAddBreadcumb($pageinfo["name"]);
                $function = $pageinfo["function"];
                $content = $this->$function($params);
            }
            else{
                $content = "Bu sayfa bulunamadı!";
            }
        }
        else{
            $currencie = CurrencyModel::beGetCurrencies("cicon",$userproduct["cid"]);
            $orderinfo = [
                "product" => $userproduct["pname"],
                "billingprice" => $upoptions["period"]["price"],
                "billingcycle" => ProductModel::beGetPeriods()[$upoptions["period"]["period"]],
                "regdate" => date("d.m.Y",$userproduct["upstime"]),
                "nextduedate" => date("d.m.Y",$userproduct["upntime"]),
                "amount" => $userproduct["upprice"],
                "currencie" => $currencie
            ];
            $content = beGetView("modules.domainnameapi.show",[
                "domain" => $updata["domain"],
                "orderinfo" => $orderinfo
            ]);
        }
        $menuitems = [];
        foreach($this->pages as $pageurl => $data){
            if(!$data["showmenu"]){
                continue;
            }
            $texturl = "";
            if($pageurl == "/"){
                $texturl = $url;
            }
            else{
                $texturl = $url."/".$pageurl;
            }
            $menuitems[] = [
                "name" => $data["name"],
                "icon" => $data["icon"],
                "url" => $texturl
            ];
        }
        $altmenu[] = [
            "name" => "Alan Adı Yönetimi",
            "menuitems" => $menuitems
        ];
        return [
            "status" => true,
            "title" => "Alan Adı Yönetimi",
            "content" => $content,
            "menus" => $altmenu
        ];
    }
    protected function beObjectToArray(&$object = null){
        $object = json_decode(json_encode($object,JSON_UNESCAPED_UNICODE),true);
    }
    protected function beConnectClient($url = ""){
        $this->dnaclient = new SoapClient("http://{$url}/DomainApi.svc?singleWsdl",[
            "trace" => true,
            "encoding" => "UTF-8",
            "features" => SOAP_SINGLE_ELEMENT_ARRAYS,
            "debug" => true,
            "exceptions" => true
        ]);
    }
}