<?php

namespace App\System\Module;

use App\System\Basic\beModel;
use App\System\Controller\ConnectionController;
use App\System\Model\SettingModel;

class netgsm {
    public function netgsm_info(){
        return [
            "name" => "NetGSM SMS Sistemi",
            "description" => "Sistem üzerinden yapılacak olan işlemleri ve bildirimleri SMS aracılığıyla da iletilmesini sağlar",
            "version" => "1.0",
            "vercode" => 10,
            "author" => "ITenGriTR"
        ];
    }
    public function netgsm_sendmessage($data = []){
        if($data["dial"] != "90"){
            return ["status" => false,"message" => "NetGsm modülü ile sadece +90 numaralara SMS gönderebilirsiniz"];
        }
        global $be;
        $globalsettings = $be->settings;
        $phone = $data["phone"];
        $message = $data["message"];
        $settings = SettingModel::beGetSettings("netgsm_usercode,netgsm_password,netgsm_header");
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,ConnectionController::beGetActiveApi()."/api/netgsm/sendmessage");
        curl_setopt($ch,CURLOPT_HEADER,false);
        curl_setopt($ch,CURLOPT_NOBODY,true);
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query([
            "header" => $settings["netgsm_header"],
            "usercode" => $settings["netgsm_usercode"],
            "password" => $settings["netgsm_password"],
            "phone" => $phone,
            "message" => $message,
            "cid" => $globalsettings["system_id"],
            "ctoken" => $globalsettings["system_token"],
            "secret" => $globalsettings["system_secret"],
            "acces_token" => substr(md5($globalsettings["system_id"].BE_TIME),0,8),
            "time" => BE_TIME
        ]));
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_IPRESOLVE,CURL_IPRESOLVE_V4);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,0);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);
        $response = curl_exec($ch);
        $httpcode = curl_getinfo($ch,CURLINFO_HTTP_CODE);
        curl_close($ch);
        if($httpcode != 200){
            return ["status" => false,"message" => "API sistemine bağlantı sağlanamadı!"];
        }
        $response = json_decode($response,true);
        if(!$response["status"]){
            return ["status" => false,"message" => $response["message"]];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde mesaj gönderildi"];
    }
}
?>