<?php

    namespace App\System\Plugin;
    use App\System\Basic\beModel;
    use App\System\Basic\beRouter;
    use App\System\Model\SettingGroupsModel;
    use App\System\Model\SettingModel;
    use App\System\Vendor\beModule;
    use App\System\Vendor\bePlugin;

    class cari_helper {
        public function plugin_info(){
            return [
                "name" => "Cari Eklentisi",
                "description" => "Cari modülününü çalışması için gerekli alt yapıyı sağlar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [
                "routes_start" => "be_routes_insert"
            ];
        }
        public function plugin_settings(){
            return ["status" => true,"url" => beGetRoute("cari.dashboard")];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("cari","Cari Fatura Resmileştirme","Cari modülü için gerekli ayarları yükler");
            bePlugin::beCreateSetting($sgid,"cari_status","Durum","GİB fatura resmişleştirmeaktiflik durumu","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"cari_email","Cari E-Mail Adresi","Cari e-arşiv portal sistemine giriş için kullandığınız email adresiniz","str");
            bePlugin::beCreateSetting($sgid,"cari_password","Cari Şifre","Cari e-arşiv portal sistemine giriş için kullandığınız şifre","str");
            bePlugin::beCreateSetting($sgid,"cari_global","Cari Genel Fatura","Cari üzerinde yurt dışından satın alım yapanlar için fatura oluştur","bool");
            bePlugin::beCreateSetting($sgid,"cari_default_no","Cari Yurt Dışı Kimlik Numarası","Cari üzerinde yurt dışı müşterilerine fatura kesilecekse atanacak olan TC Kimlik değeri","str","11111111111");
            bePlugin::beCreateSetting($sgid,"cari_data","Cari Data","","json","","");
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","cari")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
        public function be_routes_insert(){
            beRouter::bePrefix("/cari","cari.")->beGroup(function(){
                beRouter::beRoute("/","cari_helper@dashboard")->beName("dashboard")->beSpecial()->beMiddleWare(["Auth","Admin" => ["permission" => "admin_plugin_edit"]]);
                beRouter::beRoute("/test-connection","cari_helper@tect_connection_post","post")->beName("test.connetcion.post")->beSpecial()->beMiddleWare(["Auth","Admin" => ["permission" => "admin_plugin_edit"]]);
            });
        }
        public function dashboard(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","cari")->beGet();
            return beGetView("plugins.cari.dashboard",["settingsurl" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])]);
        }
        public function tect_connection_post(){
            beModule::beLoadModule("invoice.cari");
            $response = beModule::beRunModuleFunction("cari","login");
            if(!$response["status"]){
                return beAjaxError(["message" => $response["message"]]);
            }
            return beAjaxSuccess(["message" => $response["message"]]);
        }
    }

?>