<?php

    namespace App\System\Plugin;
    use App\System\Basic\beModel;
    use App\System\Basic\beRouter;
    use App\System\Controller\ConnectionController;
    use App\System\Model\SettingGroupsModel;
    use App\System\Model\SettingModel;
    use App\System\Vendor\Auth;
    use App\System\Vendor\beModule;
    use App\System\Vendor\bePlugin;

    class paytr_helper {
        public function plugin_info(){
            return [
                "name" => "PayTR Eklentisi",
                "description" => "PayTR modülününü çalışması için gerekli alt yapıyı sağlar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","paytr")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("paytr","PayTR Ödeme Yöntemi","PayTR ödeme yöntemi için gerekli ayarları yükler");
            bePlugin::beCreateSetting($sgid,"paytr_status","Durum","PayTR ödeme yöntemi aktiflik durumu","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"paytr_merchant_id","Üye İşyeri Numarası","PayTR paneli üzerinde firma ayarları alanında üye işyeri numarası","int");
            bePlugin::beCreateSetting($sgid,"paytr_merchant_key","API Anahtarı","PayTR paneli üzerinde firma ayarları alanındaki api anahtarı","str");
            bePlugin::beCreateSetting($sgid,"paytr_merchant_secret","API Güvenlik Anahtarı","PayTR paneli üzerinde firma ayarları alanındaki api güvenlik anahtarı","str");
            bePlugin::beCreateSetting($sgid,"paytr_methodfee","Komisyon Oranı","PayTR ödeme yöntemi için eklenecek olan ekstra komisyon","int");
            bePlugin::beCreateSetting($sgid,"paytr_method","Ödeme Methodu","PayTR üzerindeki ödemelerin nasıl yapılacağını belirtin","select\niframe=Iframe\ndirect=Direkt\nnon3d=Non3D","0");
            beModel::beQuery("CREATE TABLE `be_paytr_user` (`uid` int(11) NOT NULL,`icusertoken` varchar(64) NOT NULL,`icdateline` int(11) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;CREATE TABLE `be_paytr_cards` (`icid` int(11) NOT NULL,`uid` int(11) NOT NULL,`iid` int(11) NOT NULL,`iccardnumber` varchar(16) NOT NULL,`iccardexpire` varchar(8) NOT NULL,`icipaddress` varchar(64) NOT NULL,`icdateline` int(11) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;ALTER TABLE `be_paytr_cards` ADD PRIMARY KEY (`icid`);")->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            beModel::beQuery("DROP TABLE be_paytr_user,be_paytr_cards")->beExecute();
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","paytr")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
    }

?>