<?php

    namespace App\System\Plugin;
    use App\System\Basic\beModel;
    use App\System\Basic\beRouter;
    use App\System\Model\SettingGroupsModel;
    use App\System\Model\SettingModel;
    use App\System\Model\UserInfoModel;
    use App\System\Vendor\Auth;
    use App\System\Vendor\beModule;
    use App\System\Vendor\bePlugin;
    use App\System\Vendor\beSms;

    class smsapprove {
        public function plugin_info(){
            return [
                "name" => "SMS Doğrulama Eklentisi(TR)",
                "description" => "Kullanıcılar hizmetlerini yönet tuşuna basmadan önce SMS doğrulaması yapar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [
                "routes_start" => "my_routes_insert",
                "router_route_start_post" => "my_router_route_start_post",
                "admin_user_show_tabs" => "my_admin_user_show_tabs"
            ];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","smsapprove")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("smsapprove","Üst Reklam Ayarları","Üst reklam için gerekli ayarlamaları yapmayı sağlar");
            bePlugin::beCreateSetting($sgid,"smsapprove_status","Durum","Üst reklamın aktiflik durumu","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"smsapprove_second","Bekleme Süresi","Bir SMS gönderildikten sonra diğer SMS gönderimi için geçmesi gereken süre","int","60");
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","smsapprove")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
        public function my_routes_insert(){
            beRouter::beName("smsapprove.")->beGroup(function(){
                beRouter::beRoute("/smsapprove-approve","smsapprove@approve_post","post")->beName("approve.post")->beSpecial()->beMiddleWare("Auth");
                beRouter::beRoute("/smsapprove-admin-approve","smsapprove@admin_approve_post","post")->beName("admin.approve.post")->beSpecial()->beMiddleWare(["Auth","Admin" => ["permission" => "admin_plugin_edit"]]);
            });
        }
        public function my_router_route_start_post($data = []){
            $settings = SettingModel::beGetSettings("smsapprove_status,smsapprove_second");
            if(!$settings["smsapprove_status"]){
                return $data;
            }
            $user = Auth::beGetUser();
            $userinfo = UserInfoModel::beSelect("uid,acid,uisettings,uidial,uiphone")->beWhere("uid",$user["uid"])->beGet();
            if($userinfo["acid"] != 218){
                return $data;
            }
            $uisettings = json_decode($userinfo["uisettings"],true);
            if($data["route_name"] == "client.userproduct.process"){
                if(!$uisettings["smsapprove"]){
                    return ["view" => beAjaxError(["message" => "Hizmetinizi yönetebilek için SMS doğrulamasını yapmanız gerekmektedir!","url" => beGetRoute("client.userproduct.userproducts")])];
                }
            }
            if($data["route_name"] == "client.userproduct.userproducts"){
                if(!$uisettings["smsapprove"]){
                    $smscode = beModel::beTable("be_smscodes")->beWhere("sctype","2")->beWhere("scdateline",BE_TIME-(int)$settings["smsapprove_second"],">")->beGet();
                    if(!$smscode){
                        $randnumber = rand(1,9).rand(0,9).rand(0,9).rand(0,9).rand(0,9).rand(0,9);
                        beModel::beInsert([
                            "uid" => $user["uid"],
                            "sccode" => $randnumber,
                            "scdata" => "[]",
                            "scstatus" => "0",
                            "sctype" => "2",
                            "scdateline" => BE_TIME
                        ],"be_smscodes");
                        $message = "{code} kodunu kullanarak {sitename} uzerindeki aktivasyonunuzu saglayabiiblirsiniz";
                        $message = str_replace(["{sitename}","{namesurname}","{code}"],[beGetConfig("sitename"),$user["name"]." ".$user["surname"],$randnumber],$message);
                        beSms::beCreateSms($message,2,$user["uid"]);
                    }
                    return ["view" => beGetView("plugins.smsapprove.approve",["userinfo" => $userinfo])];
                }
            }
            return $data;
        }
        public function my_admin_user_show_tabs($params){
            $userinfo = UserInfoModel::beSelect("uid,uisettings")->beWhere("uid",$params["user"]["uid"])->beGet();
            $userinfo["uisettings"] = json_decode($userinfo["uisettings"],true);
            //$userinfo["uisettings"]["smsapprove"] = 1;            
            $params["tabs"]["smsapprove"] = [
                "name" => "SMS Sistemi",
                "template" => beGetView("plugins.smsapprove.usertab",["user" => $params["user"],"userinfo" => $userinfo])
            ];
            return $params;
        }
        public function approve_post(){
            $settings = SettingModel::beGetSettings("smsapprove_status,smsapprove_second");
            if(!$settings["smsapprove_status"]){
                return;
            }
            $code = $_POST["code"];
            $smscode = beModel::beTable("be_smscodes")->beWhere("sccode",$code)->beGet();
            if(!$smscode){
                return beAjaxError(["message" => "Belirtilen SMS kodu doğru değil!"]);
            }
            if(BE_TIME-$smscode["scdateline"] > (int)$settings["smsapprove_second"]){
                return beAjaxError(["message" => "Belirtilen SMS kodu geçerliliğini yitirdi!"]);
            }
            if($smscode["sctype"] != 2){
                return beAjaxError(["message" => "Belirtilen SMS kodu bu kısım için geçerli değil!"]);
            }
            $user = Auth::beGetUser();
            $userinfo = UserInfoModel::beSelect("uid,uisettings")->beWhere("uid",$user["uid"])->beGet();
            $uisettings = json_decode($userinfo["uisettings"],true);
            $uisettings["smsapprove"] = 1;
            UserInfoModel::beUpdate(["uisettings" => json_encode($uisettings,JSON_UNESCAPED_UNICODE)])->beWhere("uid",$user["uid"])->beExecute();
            return beAjaxSuccess(["message" => "Başarılı bir şekilde SMS doğrulaması tamamlandı","refresh" => 1]);
        }
        public function admin_approve_post(){
            beLanguage::beReadLang("user");
            $uid = $_POST["uid"];
            $user = Auth::beGetUser($uid,"uid");
            if(!$user){
                return beAjaxError(["message" => beGetLang("user_not_found")]);
            }
            $userinfo = UserInfoModel::beSelect("uid,uisettings")->beWhere("uid",$user["uid"])->beGet();
            $uisettings = json_decode($userinfo["uisettings"],true);
            $uisettings["smsapprove"] = 1;
            UserInfoModel::beUpdate(["uisettings" => json_encode($uisettings,JSON_UNESCAPED_UNICODE)])->beWhere("uid",$user["uid"])->beExecute();    
            return beAjaxSuccess(["message" => "Başarılı bir şekilde SMS doğrulaması onaylandı"]);        
        }
    }

?>