@extend('admin.layout')
@section('headerinclude')
<title>Banka Hesabı Düzenle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Banka Hesabı Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="bankForm">
                    <input type="hidden" class="form-control" name="bid" value="{{ $bank['bid'] }}">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Banka Adı</label>
                            <input type="text" class="form-control" name="bname" value="{{ $bank['bname'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Hesap Sahibi</label>
                            <input type="text" class="form-control" name="buser" value="{{ $bank['buser'] }}">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Banka Açıklaması</label>
                            <input type="text" class="form-control" name="bdescription" value="{{ $bank['bdescription'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Hesap Iban</label>
                            <input type="text" class="form-control" name="biban" value="{{ $bank['biban'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Banka Resim</label>
                            @if($bank['bimage'])
                            <div class="d-block my-3">
                            <img src="app/resources/upload/bank/{{ $bank['bimage'] }}" width="200" height="60">
                            </div>
                            @endif
                            <input type="file" class="form-control" name="file">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editBank">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".editBank").on("click",function(){
        if(!wait){
            $(".editBank").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.accounting.bank.edit.post') }}",
                type: "post",
                async: true,
                data: new FormData($("#bankForm")[0]),
                dataType: "json",
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function(response){
                    $(".editBank").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection