@extend('admin.layout')
@section('headerinclude')
<title>Kategori Düzenle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Kategori Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="categoryForm">
                    <div class="row">
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Adı</label>
                            <input type="text" class="form-control" name="pcname" value="{{ $category['pcname'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Tasarımı</label>
                            <select class="form-control form-control-select" name="pcpagetype">
                                @foreach($themepages as $themepage)
                                <option value="{{ $themepage['tpid'] }}"{{ $themepage['tpid'] == $category['pcpagetype'] ? ' selected':'' }}>{{ $themepage['tpname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Tablo Tasarımı</label>
                            <select class="form-control form-control-select" name="pcpagetabletype">
                                @foreach($themepages as $themepage)
                                <option value="{{ $themepage['tpid'] }}"{{ $themepage['tpid'] == $category['pcpagetabletype'] ? ' selected':'' }}>{{ $themepage['tpname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Ürün Tasarımı</label>
                            <select class="form-control form-control-select" name="pcpageitemtype">
                                @foreach($themepages as $themepage)
                                <option value="{{ $themepage['tpid'] }}"{{ $themepage['tpid'] == $category['pcpageitemtype'] ? ' selected':'' }}>{{ $themepage['tpname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editCategory">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                        <thead>
                            <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                <th class="text-center align-middle">#</th>
                                <th class="text-center align-middle">Sayfa Adı</th>
                                <th class="text-center align-middle">Dil</th>
                                <th class="text-center align-middle">Oluşturulma Tarihi</th>
                                <th class="text-center align-middle"></th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($pagetranslations as $pagetranslation)
                            <tr id="{{ $pagetranslation['ptid'] }}Row">
                                <td class="text-center align-middle">{{ $pagetranslation['ptid'] }}</td>
                                <td class="text-center align-middle">{{ $pagetranslation['ptname'] }}</td>
                                <td class="text-center align-middle">{{ $languages[$pagetranslation['lid']]['lname'] }}</td>
                                <td class="text-center align-middle">
                                    <code class="ms-0 d-block">{{ beSpecialTime($pagetranslation['ptdateline']) }}</code>
                                </td>
                                <td class="text-center align-middle">
                                    <a data-bs-toggle="tooltip" title="Görüntüle" target="_blank" href="{{ beGetRoute('admin.page.show',['pid' => $pagetranslation['pid']]) }}" class="btn btn-warning"><i class="far fa-eye"></i></a>
                                    <a data-bs-toggle="tooltip" title="Önbelleği Yenile" href="#" class="btn btn-primary beResetCache" data-lid="{{ $pagetranslation['lid'] }}">Önbelleği Temizle</a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".editCategory").on("click",function(){
        if(!wait){
            $(".editCategory").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.category.edit.post') }}",
                type: "post",
                async: true,
                data: $("#categoryForm").serialize()+"&pcid={{ $category['pcid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".editCategory").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".beResetCache").on("click",function(){
        if(!wait){
            $(".beResetCache").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            var lid = $(this).data("lid");
            $.ajax({
                url: "{{ beGetRoute('admin.category.render.post') }}",
                type: "post",
                async: true,
                data: "lid="+lid+"&pcid={{ $category['pcid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".beResetCache").html("Önbelleği Temizle");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".beDeletePage").on("click",function(){
        if(!wait){
            var item = $(this);
            var ptid = $(this).data("ptid");
            Swal.fire({
                html: "Bu işlem sonucunda alt sayfa kalıcı olarak silinecektir onaylıyor musunuz?.",
                icon: "info",
                buttonsStyling: false,
                showCancelButton: true,
                confirmButtonText: "Onaylıyorum",
                cancelButtonText: "Vazgeçtim",
                customClass: {
                    confirmButton: "btn btn-primary",
                    cancelButton: "btn btn-danger"
                }
            }).then((result) => {
                if(result.isConfirmed) {
                    wait = true;
                    item.html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
                    $.ajax({
                        url: "{{ beGetRoute('admin.page.alt.delete.post') }}",
                        type: "post",
                        async: true,
                        data: "ptid="+ptid,
                        dataType: "json",
                        crossDomain: true,
                        success: function(response){
                            item.html('<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"/><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/></svg>');
                            if(response.status){
                                Swal.fire("Başarılı",response.message,"success");
                                $("#"+ptid+"Row").remove();
                            }
                            else{
                                Swal.fire("Bir Hata Oluştu",response.message,"error");
                                wait = false;
                            }
                        }
                    });	
                }
            });
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection