@extend('admin.layout')
@section('headerinclude')
<title>Admin Ana Sayfa</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        @if($be->settings['system_data']['update'])
        <div class="card mb-10">
            <div class="card-body d-flex align-items-center p-5 p-lg-8">
                <div class="d-flex h-50px w-50px h-lg-80px w-lg-80px flex-shrink-0 flex-center position-relative align-self-start align-self-lg-center mt-3 mt-lg-0">
                    <span class="svg-icon svg-icon-primary position-absolute opacity-15">
                        <svg class=". h-50px w-50px h-lg-80px w-lg-80px ." xmlns="http://www.w3.org/2000/svg" width="70px" height="70px" viewBox="0 0 70 70" fill="none">
                            <path d="M28 4.04145C32.3316 1.54059 37.6684 1.54059 42 4.04145L58.3109 13.4585C62.6425 15.9594 65.3109 20.5812 65.3109 25.5829V44.4171C65.3109 49.4188 62.6425 54.0406 58.3109 56.5415L42 65.9585C37.6684 68.4594 32.3316 68.4594 28 65.9585L11.6891 56.5415C7.3575 54.0406 4.68911 49.4188 4.68911 44.4171V25.5829C4.68911 20.5812 7.3575 15.9594 11.6891 13.4585L28 4.04145Z" fill="currentColor"></path>
                        </svg>
                    </span>
                    <span class="svg-icon svg-icon-2x svg-icon-lg-3x svg-icon-primary position-absolute">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path opacity="0.3" d="M22.0318 8.59998C22.0318 10.4 21.4318 12.2 20.0318 13.5C18.4318 15.1 16.3318 15.7 14.2318 15.4C13.3318 15.3 12.3318 15.6 11.7318 16.3L6.93177 21.1C5.73177 22.3 3.83179 22.2 2.73179 21C1.63179 19.8 1.83177 18 2.93177 16.9L7.53178 12.3C8.23178 11.6 8.53177 10.7 8.43177 9.80005C8.13177 7.80005 8.73176 5.6 10.3318 4C11.7318 2.6 13.5318 2 15.2318 2C16.1318 2 16.6318 3.20005 15.9318 3.80005L13.0318 6.70007C12.5318 7.20007 12.4318 7.9 12.7318 8.5C13.3318 9.7 14.2318 10.6001 15.4318 11.2001C16.0318 11.5001 16.7318 11.3 17.2318 10.9L20.1318 8C20.8318 7.2 22.0318 7.59998 22.0318 8.59998Z" fill="currentColor"></path>
                            <path d="M4.23179 19.7C3.83179 19.3 3.83179 18.7 4.23179 18.3L9.73179 12.8C10.1318 12.4 10.7318 12.4 11.1318 12.8C11.5318 13.2 11.5318 13.8 11.1318 14.2L5.63179 19.7C5.23179 20.1 4.53179 20.1 4.23179 19.7Z" fill="currentColor"></path>
                        </svg>
                    </span>
                </div>
                <div class="ms-6">
                    <p class="list-unstyled text-gray-600 fw-semibold fs-6 p-0 m-0">Sistemin devamlılığı ve güvenliğin en üst seviyede tutulması için her zaman sistem güncellemelerini yapmanızı öneririz.</p>
                    <p class="list-unstyled text-gray-600 fw-semibold fs-6 p-0 m-0">Belirtilen güncelleme için <a href="{{ beGetRoute('client.update') }}">bu linkten</a> detaylı bilgi öğrenebilirsiniz lütfen güncellemeyi yapın</p>
                    <p class="list-unstyled text-gray-600 fw-semibold fs-6 p-0 m-3">Güncelleme:<code class="mx-3">{{ $be->settings['system_data']['update']['name'].' - Yama Sürümü:'.$be->settings['system_data']['update']['build'] }}</code></p>
                </div>
            </div>
        </div>
        @endif
        <div class="row">
            <div class="col-xl-3">
                <div class="card bg-light-success card-xl-stretch mb-xl-8">
                    <div class="card-body my-3">
                        <span class="card-title fw-bold text-success fs-5 mb-3 d-block">Bu Gün</span>
                        <div class="py-1">
                            <span class="fs-1 fw-bold me-2">{{ beMoneyFormat($timeprices['today']).' '.$currencie['cicon'] }}</span>
                            <span class="fw-semibold fs-7">Gelir</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3">
                <div class="card bg-light-success card-xl-stretch mb-xl-8">
                    <div class="card-body my-3">
                        <span class="card-title fw-bold text-success fs-5 mb-3 d-block">Bu Ay</span>
                        <div class="py-1">
                            <span class="fs-1 fw-bold me-2">{{ beMoneyFormat($timeprices['thismonth']).' '.$currencie['cicon'] }}</span>
                            <span class="fw-semibold fs-7">Gelir</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3">
                <div class="card bg-light-success card-xl-stretch mb-xl-8">
                    <div class="card-body my-3">
                        <span class="card-title fw-bold text-success fs-5 mb-3 d-block">Bu Yıl</span>
                        <div class="py-1">
                            <span class="fs-1 fw-bold me-2">{{ beMoneyFormat($timeprices['thisyear']).' '.$currencie['cicon'] }}</span>
                            <span class="fw-semibold fs-7">Gelir</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3">
                <div class="card bg-light-success card-xl-stretch mb-xl-8">
                    <div class="card-body my-3">
                        <span class="card-title fw-bold text-success fs-5 mb-3 d-block">Tüm Zamanlar</span>
                        <div class="py-1">
                            <span class="fs-1 fw-bold me-2">{{ beMoneyFormat($timeprices['alltime']).' '.$currencie['cicon'] }}</span>
                            <span class="fw-semibold fs-7">Gelir</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @if($timeprices['today'] < 750)
        <div class="row">
            <div class="alert alert-info d-flex align-items-center p-5 mb-10">
                <span class="svg-icon svg-icon-2hx svg-icon-info me-4">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path>
                        <path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path>
                    </svg>
                </span>
                <div class="w-100 d-flex align-items-center justify-content-between">
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-info">Bir sorun mu mevcut?</h4>
                        <span>Günlük gelirinizin düşük olduğunu fark ettik, sisteminizi kontrol etmenizi öneririz</span>
                    </div>
                    
                </div>
            </div>
        </div>
        @endif
        @foreach($plugindata['pluginstemplate'] as $template)
        {{ $template }}
        @endforeach
        @if($userproductcancellations)
        <div class="card mb-4">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">            
                    <span class="card-label fw-bold text-gray-900">Ürün İptal Talepleri</span>
                </h3>
            </div>
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Ürün</th>
                            <th class="text-center align-middle">Ad Soyad</th>
                            <th class="text-center align-middle">Tarih</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody id="productList">
                        @foreach($userproductcancellations as $userproductcancellation)
                        <tr id="{{ $userproductcancellation['upcid'] }}Row">
                            <td class="text-center align-middle">{{ $userproductcancellation['upcid'] }}</td>
                            <td class="text-center align-middle">
                                {{ $userproductcancellation['upname'] }}
                                <a href="{{ beGetRoute('admin.order.show',['upid' => $userproductcancellation['upid']]) }}">
                                    <span class="svg-icon svg-icon-2 text-warning">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                        </svg>
                                    </span>
                                </a>
                                <span class="d-block">{{ $userproductcancellation['uptag'] }}</span>
                            </td>
                            <td class="text-center align-middle">
                                {{ $userproductcancellation['name'].' '.$userproductcancellation['surname'] }}
                                <a href="{{ beGetRoute('admin.user.show',['uid' => $userproductcancellation['uid']]) }}">
                                    <span class="svg-icon svg-icon-2 text-warning">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                        </svg>
                                    </span>
                                </a>
                            </td>
                            <td class="text-center align-middle">{{ beSpecialTime($userproductcancellation['upcdateline']) }}</td>
                            <td class="text-center align-middle">
                                <a data-bs-toggle="tooltip" title="Görüntüle" href="{{ beGetRoute('admin.order.show',['upid' => $userproductcancellation['upid']]) }}" class="btn btn-warning"><i class="far fa-eye"></i></a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif
        <div class="row">
            <div class="col-6">
                <div class="card card-flush mb-10">
                    <div class="card-header">
                        <h3 class="card-title align-items-start flex-column">
                            <span class="card-label fw-bold text-gray-800">Saate Göre Gelirler</span>
                        </h3>
                        <div class="card-toolbar">
                            <a href="{{ beGetRoute('admin.accounting.list') }}">
                                <span class="svg-icon svg-icon-2 text-warning">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                        <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                        <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                    </svg>
                                </span>
                            </a>
                        </div>
                    </div>
                    <div class="card-body d-flex align-items-end px-0 pt-3 pb-5">
                        <div id="todaysinvoiceschart" style="width:100%;height:300px"></div>
                    </div>
                </div>
            </div>
            <div class="col-6">
                <div class="card card-flush mb-10">
                    <div class="card-header">
                        <h3 class="card-title align-items-start flex-column">
                            <span class="card-label fw-bold text-gray-800">Saate Göre Talepler</span>
                        </h3>
                        <div class="card-toolbar">
                            <a href="{{ beGetRoute('admin.ticket.list') }}">
                                <span class="svg-icon svg-icon-2 text-warning">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                        <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                        <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                    </svg>
                                </span>
                            </a>
                        </div>
                    </div>
                    <div class="card-body d-flex align-items-end px-0 pt-3 pb-5">
                        <div id="todaysticketsschart" style="width:100%;height:300px"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="table-responsive">
                        <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                            <thead>
                                <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                    <th class="text-center align-middle">#</th>
                                    <th class="text-center align-middle">Ürün</th>
                                    <th class="text-center align-middle">Sahip</th>
                                    <th class="text-center align-middle">Durum</th>
                                    <th class="text-center align-middle">Yenlieme Fiyatı</th>
                                    <th class="text-center align-middle">Tarihler</th>
                                    <th class="text-center align-middle">Düzenle</th>
                                </tr>
                            </thead>
                            <tbody id="orderList">

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card mb-4">
                    <div class="table-responsive">
                        <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                            <thead>
                                <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                    <th class="text-center align-middle">#</th>
                                    <th class="text-center align-middle">Sahip</th>
                                    <th class="text-center align-middle">Başlık</th>
                                    <th class="text-center align-middle">Durum</th>
                                    <th class="text-center align-middle">Son Cevap</th>
                                    <th class="text-center align-middle">Departman</th>
                                    <th class="text-center align-middle">Sorumlu</th>
                                    <th class="text-center align-middle">Etkilenen Hizmetler</th>
                                    <th class="text-center align-middle">Oluşturulma Tarihi</th>
                                    <th class="text-center align-middle">Düzenle</th>
                                </tr>
                            </thead>
                            <tbody id="ticketList">

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-7">
            <div class="card-header">
                <div class="card-title">
                    Yönetici Notları
                </div>
            </div>
            <form id="notesForm" class="card-body">
                <div>
                    <textarea class="form-control" name="notes" rows="12">{{ $adminnotes }}</textarea>
                </div>
                <div class="mt-7">
                    <button class="btn btn-primary saveOptions">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(document).ready(function(){
        $.ajax({
            url: "{{ beGetRoute('admin.order.search.post') }}",
            type: "post",
            data: {status:-2,product:0,user:"",data:"",options:0,sort:0,page:1,pageitems:5},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#orderList").empty().append(response.html);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
        $.ajax({
            url: "{{ beGetRoute('admin.ticket.search.post') }}",
            type: "post",
            data: {name:"",status:"active",depertment:0,admin:"",user:"",sort:0,page:1,pageitems:5},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#ticketList").empty().append(response.html);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    });
    var element = document.getElementById("todaysinvoiceschart");
    var height = parseInt(KTUtil.css(element, 'height'));
    var labelColor = KTUtil.getCssVariableValue('--bs-gray-500');
    var borderColor = KTUtil.getCssVariableValue('--bs-gray-200');
    var baseColor = KTUtil.getCssVariableValue('--bs-primary');
    var secondaryColor = KTUtil.getCssVariableValue('--bs-gray-300');
    @if(is_array($todayprices))
    if(element) {
        var options = {
            width: '100%',
            series: [{
                name: '',
                data: [{{ implode(',',array_values($todayprices)) }}]
            }],
            chart: {fontFamily: 'inherit',type: 'bar',height:height,toolbar:{show: false }},
            plotOptions: {bar: {horizontal: false,columnWidth: ['30%'],endingShape: 'rounded'},},
            legend: {show: false},
            dataLabels: {enabled: false},
            stroke: {show: true,width: 2,colors: ['transparent']},
            xaxis: {
                categories: [{{ implode(',',array_keys($todayprices)) }}],
                axisBorder: {show: false},
                axisTicks: {show: false},
                labels: {style: {colors: labelColor,fontSize: '12px'}}
            },
            yaxis: {labels: {style: {colors: labelColor,fontSize: '12px'}}},
            fill: {opacity:1},
            states: {
                normal:{filter:{type: 'none',value: 0}},
                hover:{filter:{type:'none',value:0}},
                active: {allowMultipleDataPointsSelection: false,filter: {type: 'none',value: 0}}
            },
            tooltip: {style: {fontSize: '12px'},y: {formatter:function(val){return "Toplam Gelir: "+val}}},
            colors: [baseColor],
            grid: {borderColor: borderColor,strokeDashArray: 4,yaxis: {lines: {show: true }}}
        };
        var chart = new ApexCharts(element, options);
        chart.render();
    }
    @endif
    var element = document.getElementById("todaysticketsschart");
    var height = parseInt(KTUtil.css(element, 'height'));
    @if(is_array($todaytickets))
    if(element) {
        var options = {
            series: [{
                name: "Açılan Talepler",
                data: [{{ implode(',',array_values($todaytickets['opened'])) }}]
            }, {
                name: 'Çözülen Talepler',
                data: [{{ implode(',',array_values($todaytickets['closed'])) }}]
            }],
            chart: {fontFamily: 'inherit',type: 'bar',height:height,toolbar:{show: false }},
            plotOptions: {bar: {horizontal: false,columnWidth: ['30%'],endingShape: 'rounded'},},
            legend: {show: false},
            dataLabels: {enabled: false},
            stroke: {show: true,width: 2,colors:['transparent']},
            xaxis: {
                categories: [{{ implode(',',array_keys($todaytickets['opened'])) }}],
                axisBorder: {show: false},
                axisTicks: {show: false},
                labels: {style: {colors: labelColor,fontSize: '12px'}}
            },
            yaxis: {labels: {style: {colors: labelColor,fontSize: '12px'}}},
            fill: {opacity: 1},
            states: {
                normal:{filter:{type: 'none',value: 0}},
                hover:{filter:{type:'none',value:0}},
                active: {allowMultipleDataPointsSelection: false,filter: {type: 'none',value: 0}}
            },
            tooltip: {style: {fontSize: '12px'},y: {formatter:function(val){return "Talep: "+val}}},
            colors: [baseColor,secondaryColor],
            grid: {borderColor: borderColor,strokeDashArray: 4,yaxis: {lines: {show: true }}}
        };
        var chart = new ApexCharts(element, options);
        chart.render();
    }
    @endif
    $("#orderList").on("click",".btnOrderDelete",function(){
        var upid = $(this).data("upid");
        Swal.fire({
            html: "Bu siparişi silmek istediğinize emin misiniz ?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.order.delete.post') }}",
                    type: "post",
                    data: {upid:upid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+upid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
    $("#ticketList").on("click",".btnTicketDelete",function(){
        var tid = $(this).data("tid");
        Swal.fire({
            html: "Bu talebi silmek istediğinize emin misiniz ?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.ticket.delete.post') }}",
                    type: "post",
                    data: {tid:tid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+tid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
</script>
@endsection