@extend('admin.layout')
@section('headerinclude')
<title>Dil Ekle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Dil Ekle
                </div>
            </div>
            <div class="card-body">
                <form id="botForm">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Dil Adı</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Dil Kodu</label>
                            <input type="text" class="form-control" name="code" maxlength="2">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addLanguage">Ekle</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".addLanguage").on("click",function(){
        if(!wait){
            $(".addLanguage").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.language.add.post') }}",
                type: "post",
                async: true,
                data: $("#botForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".addLanguage").html("Ekle");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection