@extend('admin.layout')
@section('headerinclude')
<title>Dil Düzenle</title>
<style>
.accordpool.active {
    display: flex;
    flex-shrink: 0;
    transition: all 0.2s ease-in-out;
    transform: rotate(90deg);
    align-items: center;
    justify-content: center;
    color: var(--kt-primary);
}
.accordpool.active > span {
    color: var(--kt-primary);
}
</style>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Dil Ayarlar
                </div>
            </div>
            <div class="card-body">
                <form id="languageForm">
                    <div class="row">
                        @php $langcounter = [] @endphp
                        @foreach($editdata as $type => $data)
                        @php if(!$langcounter[$type]){
                            $langcounter[$type] = 0;
                        } 
                        @endphp
                        <div class="col-12 my-2" data-host="{{ $host['hid'] }}">
                            <div class="card card-bordered">
                                <div class="card-header">
                                    <div class="card-title">
                                        <h3 class="card-label">{{ $type }}</h3>
                                    </div>
                                    <div class="card-toolbar">
                                        <span class="accordion-icon accordpool" data-type="{{ $type }}">
                                            <span class="svg-icon svg-icon-1">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <rect opacity="0.5" x="18" y="13" width="13" height="2" rx="1" transform="rotate(-180 18 13)" fill="currentColor"></rect>
                                                    <path d="M15.4343 12.5657L11.25 16.75C10.8358 17.1642 10.8358 17.8358 11.25 18.25C11.6642 18.6642 12.3358 18.6642 12.75 18.25L18.2929 12.7071C18.6834 12.3166 18.6834 11.6834 18.2929 11.2929L12.75 5.75C12.3358 5.33579 11.6642 5.33579 11.25 5.75C10.8358 6.16421 10.8358 6.83579 11.25 7.25L15.4343 11.4343C15.7467 11.7467 15.7467 12.2533 15.4343 12.5657Z" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                                <div id="languagecontent{{ $type }}" data-status="0" style="display:none">
                                    <div class="card-body" id="languagedata{{ $type }}">
                                    @foreach($data as $key => $val)
                                    <div class="row" id="langdatarea[{{ $type }}][{{ $langcounter[$type] }}]">
                                        <div class="col-3 mb-9">
                                            <input type="text" class="form-control" name="lang[{{ $type }}][{{ $langcounter[$type] }}][key]" value="{{ $key }}">
                                        </div>
                                        <div class="col-8 mb-9">
                                            <input type="text" class="form-control" name="lang[{{ $type }}][{{ $langcounter[$type] }}][val]" value="{{ $val }}">
                                        </div>
                                        <div class="col-1 mb-9">
                                            <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDelete" data-area="langdatarea[{{ $type }}][{{ $langcounter[$type] }}]">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>
                                            </a>
                                        </div>
                                    </div>
                                    @php $langcounter[$type] += 1 @endphp
                                    @endforeach
                                    <div class="col-12">
                                        <button class="btn btn-success d-block m-auto addLanguageData" data-languagedata="{{ $type }}">Yeni Veri Ekle</button>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editLangugae">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var lastkeys = {};
    @foreach($langcounter as $key => $value)
    @if(!$value)
    @php $value = 0; @endphp
    @endif
    lastkeys["{{ $key }}"] = {{ $value+1 }};
    @endforeach
    $(".accordpool").on("click",function(){
        var type = $(this).data("type");
        var content = $("#languagecontent"+type);
        if(content.attr("data-status") == "0"){
            content.attr("data-status","1");
            $(this).addClass("active");
            content.show();
        }
        else{
            content.attr("data-status","0");
            $(this).removeClass("active");
            content.hide();
        }
        return false;
    });
    $(".addLanguageData").on("click",function(){
        var languagedata = $(this).data("languagedata");
        $("#languagedata"+languagedata).prepend('<div class="row" id="langdatarea['+languagedata+']['+lastkeys[languagedata]+']">\
            <div class="col-3 mb-9">\
                <input type="text" class="form-control" name="lang['+languagedata+']['+lastkeys[languagedata]+'][key]" value="">\
            </div>\
            <div class="col-8 mb-9">\
                <input type="text" class="form-control" name="lang['+languagedata+']['+lastkeys[languagedata]+'][val]" value="">\
            </div>\
            <div class="col-1 mb-9">\
                <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDelete" data-area="langdatarea['+languagedata+']['+lastkeys[languagedata]+']">\
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>\
                </a>\
            </div>\
        </div>');
        lastkeys[languagedata] += 1;
        return false;
    });
    $("#languageForm").on("click",".btnDelete",function(){
        var area = $(this).data("area");
        document.getElementById(area).remove();
        return false;
    });
    var wait = false;
    $(".editLangugae").on("click",function(){
        if(!wait){
            $(".editLangugae").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.language.edit.post') }}",
                type: "post",
                async: true,
                data: "lid={{ $language['lid'] }}&"+$("#languageForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    if(response.status){
                        $(".editLangugae").html('Kaydet');
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        $(".editLangugae").html('Kaydet');
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection