@extend('admin.layout')
@section('headerinclude')
<title>Sipariş Ekle</title>
<style>
.table-summary ul {
    list-style: none;
}
.table-summary ul li i {
    margin-right: 5px;
    color: #fff;
}
.table-summary .buttons {
    display: flex;
    justify-content: center;
}
.table-summary .separator {
    height: 1px;
    margin: 15px 0;
    background-color: #fff;
    opacity: .5;
}
.table-data {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin: 16px 0px;
}
.table-summary span {
    color: #fff;
}
</style>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="row">
            <div class="col-md-8">
                <div class="card mb-10">
                    <div class="card-header">
                        <div class="card-title">
                            Sipariş Oluştur
                        </div>
                    </div>
                    <div class="card-body">
                        <form id="productForm">
                            <div class="row">
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Müşteri</label>
                                    <select class="form-control form-control-select-user" name="order_uid"></select>
                                </div>
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sipariş Durumu</label>
                                    <select class="form-control form-control-select" name="order_status">
                                        @foreach($orderstatus as $status => $statustext)
                                        <option value="{{ $status }}"{{ $status == 0 ? ' selected':'' }}>{{ $statustext[0] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sipariş Adeti</label>
                                    <input type="number" class="form-control" name="order_count" value="1">
                                </div>
                                <div class="col-12 mb-9">
                                    <div class="form-check form-switch">
                                        <input type="hidden" name="order_onmodule" value="0">
                                        <input class="form-check-input" type="checkbox" role="switch" id="useOnModule" name="order_onmodule" value="1">
                                        <label class="form-check-label" for="useOnModule">Mümkünse modül üzerinde uygula</label>
                                    </div>
                                </div>
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Ürün</label>
                                    <select class="form-control form-control-select" name="pid" id="productSelect">
                                        <option value="0" selected>Seçiniz</option>
                                        @foreach($products as $product)
                                        <option value="{{ $product['pid'] }}">{{ $product['pname'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="beProductContent d-none">
                                    <hr class="py-3">
                                    <div class="card bg-light mb-9">
                                        <div class="card-body pt-6">
                                            <div class="bePeriodArea row">

                                            </div>
                                        </div>
                                    </div>
                                    <div class="card bg-light mb-9">
                                        <div class="card-body pt-6">
                                            <div class="beAddonArea row">

                                            </div>
                                        </div>
                                    </div>
                                    <div class="card bg-light mb-9">
                                        <div class="card-body pt-6">
                                            <div class="beAutomationArea row">

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            Sipariş Özeti
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 table-summary">
                                <ul>
                                    <li id="optionInfo">

                                    </li>
                                    <li class="separator"></li>
                                    <li>
                                        <div class="table-data">
                                            <span>Ara Toplam</span>
                                            <span id="productPrice">0 TL</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="table-data">
                                            <span>KDV(%<div id="totalFee" style="display:contents"></div>)</span>
                                            <span id="ratePrice">0 TL</span>
                                        </div>
                                    </li>
                                    <li class="separator"></li>
                                    <li class="mb-2">
                                        <div class="table-data">
                                            <span>Toplam</span>
                                            <span id="totalPrice">0 TL</span>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-12">
                                <button class="btn btn-success d-block m-auto addOrder">Oluştur</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    $(".form-control-select").select2();
    $(".form-control-select-user").select2({
        placeholder: "Lütfen aramak istediğiniz kullanıcının isim yada soyisimini giriniz",
        minimumInputLength: 2,
        tags: false,
        ajax: {
            url: "{{ beGetRoute('admin.user.find.post') }}",
            dataType: "json",
            type: "post",
            quietMillis: 50,
            data: function (term) {
                return term;
            },
            processResults: function (data){
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.namesurname,
                            id: item.uid
                        }
                    })
                };
            },
            cache: true
        }
    });
    var arealoaded = false,firsttime = true;;
    $("#productSelect").change(function(){
        var pid = $(this).val();
        $.ajax({
            url: "{{ beGetRoute('admin.product.period.get.post') }}",
            type: "post",
            async: true,
            data: {pid:pid},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $(".beProductContent").removeClass("d-none");
                    $(".bePeriodArea").empty().append(response.html);
                    checkPrice();
                    arealoaded = true;
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
        $.ajax({
            url: "{{ beGetRoute('admin.product.automation.module.get.post') }}",
            type: "post",
            async: true,
            data: {pid:pid},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $(".beAutomationArea").empty().append(response.automation);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
    });
    $("#productForm").on("change",".configureSelect",function(){
        if(arealoaded == true){
            checkPrice();
        }
    });
    function checkPrice(){
        var icon = "",periodtext = "";
        $.ajax({
            url: "{{ beGetRoute('admin.product.addon.get.post') }}?{{ $_SERVER['QUERY_STRING'] }}",
            type: "post",
            data: $("#productForm").serialize(),
            dataType: "json",
            crossDomain: true,
            success: function(response){
                $("#optionInfo").empty();
                icon = response.icon;
                if(response.periodoptions[1] > 0){
                    periodtext = response.periodoptions[1]+" "+response.periodoptions[2];
                }
                else{
                    periodtext = response.periodoptions[2];
                }
                $("#optionInfo").append('<div class="table-data"><div><span>'+response.periodoptions[0]+'</span><span style="display:block;font-size:14px;opacity:0.7">'+periodtext+'</span></div><div><span>'+response.periodoptions[3]+icon+'</span></div></div>');
                $.each(response.addonoptions,function(index,val){
                    if(val[2] > 0){
                        periodtext = val[2]+" "+val[3];
                    }
                    else{
                        periodtext = "";
                    }
                    $("#optionInfo").append('<div class="table-data"><div><span>'+val[0]+'</span><span style="display:block;font-size:14px;opacity:0.9">Seçim: '+val[1]+'</span><span style="display:block;font-size:14px;opacity:0.7">'+periodtext+'</span></div><div><span>'+val[4]+icon+'</span></div></div>');
                });
                $(".beAddonArea").empty().append(response.addonoptionshtml);
                $("#productPrice").html(response.productprice+" "+icon);
                $("#ratePrice").html(response.totalrate+" "+icon);
                $("#totalPrice").html(response.totalprice+" "+icon);
                $("#totalFee").html(response.fee);
                if(firsttime){
                    checkPrice();
                    firsttime = false;
                }
            }
        });
    }
    var wait = false;
    $(".addOrder").on("click",function(){
        if(!wait){
            $(".addOrder").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.order.add.post') }}?{{ $_SERVER['QUERY_STRING'] }}",
                type: "post",
                data: $("#productForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".addOrder").html("Oluştur");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection