@extend('admin.layout')
@section('headerinclude')
<title>Siparişler</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="{{ beGetRoute('admin.order.add') }}" class="d-inline-flex align-items-center btn btn-primary mb-5 mx-3">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Yeni Ekle
            </a>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Durum</label>
                        <select class="form-control form-control-select" id="searchOrderStatus">
                            <option value="-2">Hepsi</option>
                            <option value="2">Aktif</option>
                            <option value="1">Aktif(Kurulum Öncesi)</option>
                            <option value="0">Beklemede</option>
                            <option value="-1">İptal Edilmişler</option>
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Ürün</label>
                        <select class="form-control form-control-select" id="searchOrderProduct">
                            <option value="0">Seçiniz</option>
                            @foreach($products as $pid => $product)
                                <option value="{{ $pid }}">{{ $product }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Ürün Sahibi</label>
                        <input type="text" class="form-control" id="searchOrderUser" placeholder="Aramak istediğiniz kişinin adını soyadını adresini giriniz">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Ürün Verisi</label>
                        <input type="text" class="form-control" id="searchOrderData" placeholder="Aramak istediğiniz ürünün verisini giriniz">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Opsiyonlar</label>
                        <select class="form-control form-control-select" id="searchOrderOptions">
                            <option value="0">Seçiniz</option>
                            <option value="1">Kalan Süre</option>
                            <option value="2">Yenileme Fiyatı</option>
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Sıralama Türü</label>
                        <select class="form-control form-control-select" id="searchOrderSort">
                            <option value="1">Sondan Başa</option>
                            <option value="2">Baştan Sona</option>
                        </select>
                    </div>
                    <div class="col-12 d-flex justify-content-center mt-5">
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFind btn-primary mx-2">
                            <i class="fonticon-equalizer fs-4 me-1"></i>
                            Ara
                        </a>
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFindEmpty btn-warning mx-2">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>
                            Temizle
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="alert alert-warning d-flex align-items-center p-5">
            <span class="svg-icon svg-icon-2hx svg-icon-warning me-4">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor"></rect>
                    <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor"></path>
                </svg>
            </span>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-warning">Toplam Siarpiş Adedi</h4>
                <span id="orderCount"></span>
            </div>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Ürün</th>
                            <th class="text-center align-middle">Sahip</th>
                            <th class="text-center align-middle">Durum</th>
                            <th class="text-center align-middle">Yenlieme Fiyatı</th>
                            <th class="text-center align-middle">Tarihler</th>
                            <th class="text-center align-middle">Düzenle</th>
                        </tr>
                    </thead>
                    <tbody id="orderList">

                    </tbody>
                </table>
            </div>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row" id="paganation">
                    
                </div>
            </div>
        </div>
        <div class="card mb-4">
            <div class="card-header">
                <div class="card-title">
                    Toplu İşlemler
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12 mb-9">
                        <label class="fs-6 fw-semibold mb-2 d-block">Modül Etkileşimi</label>
                        <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">İşlem yapılan siparişlerde eğer modül üzerinde işlem yapılabiliyorsa işlemi gerçekleştir.</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" role="switch" id="orderTotalOnModule">
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <a href="#" class="btn btn-success beActionOrderAll" data-status="2">Toplu Aktif Et</a>
                <a href="#" class="btn btn-primary beActionOrderAll" data-status="1">Toplu Aktif(K.Ö) Yap</a>
                <a href="#" class="btn btn-info beActionOrderAll" data-status="0">Toplu Beklemeye Al</a>
                <a href="#" class="btn btn-danger beActionOrderAll" data-status="-1">Toplu İptal Et</a>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var page = 1;
    $(".beActionOrderAll").on("click",function(){
        var status = parseInt($(this).data("status"));
        var upids = [];
        $(".beOrderCheckbox").each(function(index){
            if($(this).is(":checked")){
                upids.push($(this).data("upid"))
            }
        });
        var onmodule = $("#orderTotalOnModule").is(":checked") == true ? 1:0
        $.ajax({
            url: "{{ beGetRoute('admin.order.status.save.post') }}",
            type: "post",
            async: true,
            data: {upids:upids,status:status,onmodule:onmodule},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                wait1 = false;
                if(response.status){
                    Swal.fire("Başarılı",response.message,"success");
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
        return false;
    });
    $("#orderList").on("click",".btnOrderDelete",function(){
        var upid = $(this).data("upid");
        Swal.fire({
            html: "Bu siparişi silmek istediğinize emin misiniz ?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.order.delete.post') }}",
                    type: "post",
                    data: {upid:upid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+upid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
    $(".btnFind").on("click",function(){
        var status = $("#searchOrderStatus").val();
        if(status < 0 || status > 2){
            status = -2;
        }
        var product = $("#searchOrderProduct").val();
        if(!product){
            product = 0;
        }
        var user = $("#searchOrderUser").val();
        var data = $("#searchOrderData").val();
        var options = $("#searchOrderOptions").val();
        if(!options){
            options = 0;
        }
        var sort = $("#searchOrderSort").val();
        if(!sort){
            sort = 0;
        }
        beSearchOrder(status,product,user,data,options,sort);
        return false;
    });
    $(".btnFindEmpty").on("click",function(){
        $("#searchOrderStatus option:first").attr("selected","selected");
        $("#searchOrderProduct option:first").attr("selected","selected");
        $("#searchOrderUser").val("");
        $("#searchOrderData").val("");
        $("#searchOrderOptions option:first").attr("selected","selected");
        $("#searchOrderSort option:first").attr("selected","selected");
        beSearchOrder(-2,0,"","",0,0);
        return false;
    });
    $("#paganation").on("click",".goPaganation",function(){
        page = parseInt($(this).data("page"));
        $(".btnFind").trigger("click");
        return false;
    });
    $(document).ready(function(){
        beSearchOrder(-2,0,"","",0,0);
    });
    function beSearchOrder(status,product,user,data,options,sort){
        $.ajax({
            url: "{{ beGetRoute('admin.order.search.post') }}",
            type: "post",
            data: {status:status,product:product,username:user,data:data,options:options,sort:sort,page:page},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#paganation").empty().append(response.paganation);
                    $("#orderList").empty().append(response.html);
                    $("#orderCount").empty().append(response.ordercount+" Adet");
                    $(".form-control-select").select2();
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
</script>
@endsection