@foreach($configs as $key => $config)
    @if($config['type'] == 'select')
    <div class="{{ $config['form-view']['class'] ?? 'col-12' }} mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <span class="fs-8 text-gray-500 fw-semibold d-block mb-2">* {{ $config['description'] }}</span>
        <select class="form-control form-control-select" name="{{ $key }}">
            @foreach($config['values'] as $altkey => $value)
            <option value="{{ $altkey }}"{{ $productmodules[$key] == $altkey ? ' selected':'' }}>{{ $value }}</option>
            @endforeach
        </select>
    </div>
    @elseif($config['type'] == 'multpileselect')
    <div class="{{ $config['form-view']['class'] ?? 'col-12' }} mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <span class="fs-8 text-gray-500 fw-semibold d-block mb-2">* {{ $config['description'] }}</span>
        <select class="form-control form-control-select" name="{{ $key }}[]" multiple>
            @foreach($config['values'] as $altkey => $value)
            <option value="{{ $altkey }}"{{ $productmodules[$key] == $altkey ? ' selected':'' }}>{{ $value }}</option>
            @endforeach
        </select>
    </div>
    @elseif($config['type'] == 'string')
    <div class="{{ $config['form-view']['class'] ?? 'col-12' }} mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <span class="fs-8 text-gray-500 fw-semibold d-block mb-2">* {{ $config['description'] }}</span>
        <input type="text" class="form-control" name="{{ $key }}" value="{{ $productmodules[$key] }}">
    </div>
    @elseif($config['type'] == 'integer')
    <div class="{{ $config['form-view']['class'] ?? 'col-12' }} mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <span class="fs-8 text-gray-500 fw-semibold d-block mb-2">* {{ $config['description'] }}</span>
        <input type="number" class="form-control" name="{{ $key }}" value="{{ $productmodules[$key] }}">
    </div>
    @elseif($config['type'] == 'float')
    <div class="{{ $config['form-view']['class'] ?? 'col-12' }} mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <span class="fs-8 text-gray-500 fw-semibold d-block mb-2">* {{ $config['description'] }}</span>
        <input type="string" class="form-control" name="{{ $key }}" value="{{ $productmodules[$key] }}">
    </div>
    @elseif($config['type'] == 'date')
    <div class="{{ $config['form-view']['class'] ?? 'col-12' }} mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <span class="fs-8 text-gray-500 fw-semibold d-block mb-2">* {{ $config['description'] }}</span>
        <input type="datetime-local" class="form-control" name="{{ $key }}" value="{{ date('Y-m-d\TH:i',$productmodules[$key]) }}">
    </div>
    @endif
@endforeach