@extend('admin.layout')
@section('headerinclude')
<title>Ürün Kopyala</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Ürün Kopyala
                </div>
            </div>
            <div class="card-body">
                <form id="copyProductForm" enctype="multipart/form-data">
                    <input type="hidden" name="pid" value="{{ $product['pid'] }}">
                    <div class="row">
                        <div class="col-12 mb-9">
                            <div class="d-flex align-items-center rounded py-5 px-5 bg-light-info mb-7">
                                <span class="svg-icon svg-icon-3x svg-icon-info me-5">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="10" fill="currentColor"></rect>
                                        <rect x="11" y="14" width="7" height="2" rx="1" transform="rotate(-90 11 14)" fill="currentColor"></rect>
                                        <rect x="11" y="17" width="2" height="2" rx="1" transform="rotate(-90 11 17)" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                <div class="fw-bold fs-7 text-white">Kopyalanan Ürün: {{ $product['pname'] }}</div>
                            </div>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ürün Adı Giriniz</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Seçiniz</label>
                            <select class="form-control form-control-select" name="categories[]" multiple>
                                <option value="0">Kategori Seçin</option>
                                @foreach($categories as $category)
                                <option value="{{ $category['pcid'] }}"{{ in_array($category['pcid'],$product['pcids']) ? 'selected':'' }}>{{ $category['pcname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ürün Resmi Seçiniz</label>
                            <input type="file" class="form-control" name="image">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Stok Adedi Giriniz(Sınırsız -1)</label>
                            <input type="number" class="form-control" name="stock" value="{{ $product['pstock'] }}">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto copyProduct">Kopyala</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    var wait = false;
    $(".form-control-select").select2();
    $(".copyProduct").on("click",function(){
        if(!wait){
            $(".copyProduct").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.product.copy.post') }}",
                type: "post",
                async: true,
                data: new FormData($("#copyProductForm")[0]),
                dataType: "json",
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function(response){
                    $(".copyProduct").html("Kaydet");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection