@extend('admin.layout')
@section('headerinclude')
<title>Kullanıcı Oluştur</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Kullanıcı Oluştur
                </div>
            </div>
            <div class="card-body">
                <form id="userForm">
                    <div class="row">
                        <div class="col-3 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ad</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-3 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Soyad</label>
                            <input type="text" class="form-control" name="surname">
                        </div>
                        <div class="col-3 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Mail</label>
                            <input type="text" class="form-control" name="email">
                        </div>
                        <div class="col-3 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Şifre</label>
                            <input type="text" class="form-control" name="password">
                        </div>
                        <div class="col-3 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Grup</label>
                            <select class="form-control form-control-select" name="usergroup">
                                @foreach($usergroups as $usergroup)
                                <option value="{{ $usergroup['ugid'] }}">{{ $usergroup['ugname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-3 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Dil</label>
                            <select class="form-control form-control-select" name="language">
                                <option value="0" selected>Tüm Ülkeler</option>
                                @foreach($languages as $language)
                                    <option value="{{ $language['lid'] }}">{{ $language['lname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-3 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Para Birimi</label>
                            <select class="form-control form-control-select" name="currency">
                                @foreach($currencies as $currency)
                                <option value="{{ $currency['cid'] }}">{{ $currency['cname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-3 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Bakiye</label>
                            <input type="number" class="form-control" name="money" value="0">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ülke</label>
                            <select class="form-control form-control-select" name="country">
                                <option value="0" selected>Tüm Ülkeler</option>
                                @foreach($countries as $country)
                                    <option value="{{ $country['acid'] }}"{{ $system_country == $country['acid'] ? ' selected':'' }}>{{ $country['acname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">İl</label>
                            <input type="text" class="form-control" name="district">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">İlçe</label>
                            <input type="text" class="form-control" name="province">
                        </div>
                        <div class="col-2 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ülke Kodu</label>
                            <input type="text" class="form-control" name="dial" value="+90">
                        </div>
                        <div class="col-3 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Telefon Numarası</label>
                            <input type="text" class="form-control" name="phone">
                        </div>
                        <div class="col-7 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Adres</label>
                            <input type="text" class="form-control" name="address">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addUser">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var wait = false;
    $(".addUser").on("click",function(){
        if(!wait){
            $(".addUser").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.user.add.post') }}",
                type: "post",
                async: true,
                data: $("#userForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".addUser").html("Kaydet");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000)
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection