@extend('clientarea.layout')
@section('title')Müşteri Paneli - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="row row-space mb-4">
    <div class="col-5 col-md-12 mb-4">
        <div class="card">
            <div class="card-header p-min">
                <div>
                    <span class="card-title"><i class="ri-user-line"></i> Müşteri Bilgilerim</span>
                </div>
                <div>
                    <a href="{{ beGetRoute('client.settings') }}" class="btn btn-white btn-sm mr-2">
                        <i class="ri-pencil-line"></i>
                        Düzenle
                    </a>
                </div>
            </div>
            <div class="card-content">
                <div class="col-12 mb-3">
                    <span class="text-lg text-hard">{{ $user['name'].' '.$user['surname'] }}</span>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <span>Mail:</span>
                    </div>
                    <div class="col-8">
                        <span class="text-normal">{{ $user['email'] }}</span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <span>Telefon:</span>
                    </div>
                    <div class="col-8">
                        <span class="text-normal">+{{ $userinfo['uidial'].' '.$userinfo['uiphone'] }}</span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <span>Adres:</span>
                    </div>
                    <div class="col-8">
                        <span class="text-normal">{{ $userinfo['uiaddress'] }}</span>
                    </div>
                </div>
                @if($be->settings['system_localmoney'])
                <div class="row">
                    <div class="col-3">
                        <span>Bakiye:</span>
                    </div>
                    <div class="col-8">
                        <span class="text-normal">{{ $user['money'].' '.$currency['cicon'] }}</span>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    @if($userproducts)
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-shopping-cart-line"></i> Hizmetlerim</span>
                </div>
            </div>
            <div class="card-content">
                <table class="btable">
                    <thead>
                        <tr>
                            <th>Hizmet No</th>
                            <th>Hizmet</th>
                            <th>Ücret</th>
                            <th>Sonraki Ödeme Tarihi</th>
                            <th>Kalan Gün</th>
                            <th>Durum</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($userproducts)
                        @foreach($userproducts as $userproduct)
                        <tr>
                            <td>
                                <span>#{{ $userproduct['upid'] }}</span>
                            </td>
                            <td>
                                <div>
                                    <span class="first-row">{{ $userproduct['upname'] }}</span>
                                    <span class="second-row text-sm">{{ $userproduct['uptag'] }}</span>
                                </div>
                            </td>
                            <td>
                                <span class="first-row">{{ beMoneyFormat($userproduct['upprice']).' '.$currencies[$userproduct['cid']]['cicon'] }}</span>
                            </td>
                            <td>
                                <span class="first-row">{{ $userproduct['enddate'] }}</span>
                                <span class="second-row {{ $userproduct['endclass'] }}">{{ $userproduct['endtext'] }}</span>
                            </td>
                            <td>
                                <span class="btn btn-{{ $userproductstatus[$userproduct['upstatus']][1] }}">
                                    {{ $userproductstatus[$userproduct['upstatus']][0] }}
                                </span>
                            </td>
                            <td>
                                <div class="buttons">
                                    <a href="#" class="btn btn-primary beCallRequest" data-url="{{ beGetRoute('client.userproduct.process') }}" data-data="action=manage&upid={{ $userproduct['upid'] }}">
                                        <i class="ri-terminal-box-line"></i>
                                        Yönet
                                    </a>
                                    @if($userproduct['pextend'] == '1')
                                        <a href="#" class="btn btn-warning beCallRequest ml-2" data-url="{{ beGetRoute('client.userproduct.process') }}" data-data="action=extend&upid={{ $userproduct['upid'] }}">
                                            <i class="ri-timer-flash-line"></i>
                                            Uzat
                                        </a>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="6">
                                <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
                <div class="card-info">
                    <div>
                        <span><b>{{ $product_count }}</b> adet hizmetiniz bulunuyor!</span>
                    </div>
                    <div class="buttons">
                        <a href="{{ beGetRoute('client.userproduct.userproducts') }}" class="btn btn-transparent btn-sm">
                            <i class="ri-eye-line"></i>
                            Tüm Hizmetleri Görüntüle
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    @if($invoices)
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> Ödemesi Yaklaşan Faturalarım</span>
                </div>
            </div>
            <div class="card-content">
                <table class="btable">
                    <thead>
                        <tr>
                            <th>Fatura No</th>
                            <th>Fatura</th>
                            <th>Tutar</th>
                            <th>Son Ödeme Tarihi</th>
                            <th>Durum</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                    @if($invoices)
                        @foreach($invoices as $invoice)
                        <tr>
                            <td>
                                <input class="form-check-input checkExtend" type="checkbox" data-upid="{{ $invoice['iid'] }}">
                                <span># dPi-{{ $invoice['iid'] }}</span>
                            </td>
                            <td>
                                <div>
                                    <span class="first-row">{{ $invoice['iname'] }}</span>
                                    <span class="second-row">{{ $invoice['idescription'] }}</span>
                                </div>
                            </td>
                            <td>
                                <span class="first-row">{{ beMoneyFormat($invoice['iprice']).' '.$currencies[$invoice['cid']]['cicon'] }}</span>
                            </td>
                            <td>
                                <span class="first-row">{{ beSpecialTime($invoice['iexpiredate']) }}</span>
                            </td>
                            <td>
                                <span class="btn btn-special">
                                    {{ $invoicestatus[$invoice['istatus']][0] }}
                                </span>
                            </td>
                            <td>
                                <div class="buttons">
                                    @if($invoice['istatus'] == 0)
                                    <a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}?action=pay" class="btn btn-primary btn-sm mr-2">
                                        <i class="ri-secure-payment-line"></i>
                                        Öde
                                    </a>
                                    @endif
                                    <a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}" class="btn btn-transparent btn-sm">
                                        <i class="ri-eye-line"></i>
                                        Görüntüle
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="6">
                                <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
                <div class="card-info">
                    <div>
                        <span>Ödenmemiş <b>{{ $invoice_count }}</b> adet faturanız bulunuyor!</span>
                    </div>
                    <div class="buttons">
                        <a href="{{ beGetRoute('client.invoice.invoices.unpaid') }}" class="btn btn-transparent btn-sm">
                            <i class="ri-eye-line"></i>
                            Tüm Faturaları Görüntüle
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-header p-min">
                <div>
                    <span class="card-title"><i class="ri-coupon-line"></i> Son Destek Taleplerim</span>
                </div>
                <div>
                    <a href="{{ beGetRoute('client.ticket.newticket') }}" class="btn btn-white btn-sm mr-2">
                        <i class="ri-coupon-3-line"></i>
                        Yeni Talep Oluştur
                    </a>
                </div>
            </div>
            <div class="card-content">
                <table class="btable">
                    <thead>
                        <tr>
                            <th>Talep No</th>
                            <th>Başlık</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($tickets)
                        @foreach($tickets as $ticket)
                        <tr>
                            <td>
                                <input class="form-check-input checkExtend" type="checkbox" data-upid="1">
                                <span># dPt-{{ $ticket['tid'] }}</span>
                            </td>
                            <td>
                                <div>
                                    <span class="first-row">{{ $ticket['tsubject'] }}</span>
                                </div>
                            </td>
                            <td>
                                <div class="buttons">
                                    <a href="{{ beGetRoute('client.ticket.ticket',['tid' => $ticket['tid']]) }}" class="btn btn-transparent btn-sm">
                                        Görüntüle
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="6">
                                <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection