@extend('clientarea.layout')
@section('title'){{ $table_name }} - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card mb-5">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-git-repository-line"></i> {{ $table_name }}</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Fatura No</th>
                    <th>Fatura</th>
                    <th>Tutar</th>
                    <th>Son Ödeme Tarihi</th>
                    <th>Durum</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @if($invoices)
                @foreach($invoices as $invoice)
                <tr>
                    <td>
                        <input class="form-check-input checkSelectedInvoice" type="checkbox" data-iid="{{ $invoice['iid'] }}">
                        <span># dPi-{{ $invoice['iid'] }}</span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row">{{ $invoice['iname'] }}</span>
                            <span class="second-row">{{ $invoice['idescription'] }}</span>
                        </div>
                    </td>
                    <td>
                        <span class="first-row">{{ beMoneyFormat($invoice['iprice']).' '.$currencies[$invoice['cid']]['cicon'] }}</span>
                    </td>
                    <td>
                        <span class="first-row">{{ beSpecialTime($invoice['iexpiredate']) }}</span>
                    </td>
                    <td>
                        <span class="btn btn-{{ $invoicestatus[$invoice['istatus']][1] }}">
                            {{ $invoicestatus[$invoice['istatus']][0] }}
                        </span>
                    </td>
                    <td>
                        <div class="buttons">
                            @if($invoice['istatus'] == 0)
                            <a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}?action=pay" class="btn btn-primary btn-sm mr-2">
                                <i class="ri-secure-payment-line"></i>
                                Öde
                            </a>
                            @endif
                            <a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}" class="btn btn-transparent btn-sm">
                                <i class="ri-eye-line"></i>
                                Görüntüle
                            </a>
                            @if($invoice['ibill'] == 2)
                            @php $ibilldata = json_decode($invoice['ibilldata'],true); @endphp
                            @if($ibilldata['aid'])
                            <a href="{{ beGetRoute('file.show.special',['aid' => $ibilldata['aid']]) }}" class="btn btn-success btn-sm ml-2">
                                Resmi Fatura
                            </a>
                            @endif
                            @endif
                        </div>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
        <div class="card-info">
            <div>
                <span>Ödenmemiş <b>{{ $invoice_count }}</b> adet faturanız bulunuyor!</span>
            </div>
            <div class="buttons">
                <a class="btn btn-primary btn-sm beMergeSelecteds" href="#">
                    <i class="ri-rest-time-line"></i>
                    Seçilenleri Birleştir
                </a>
            </div>
        </div>
    </div>
</div>
<div class="card row-flex row-center">
    {{ $paganation['paganation'] }}
</div>
@endsection
@section('js')
<script>
$(".beMergeSelecteds").on("click",function(){
    var iids = [],query = "";
    $(".checkSelectedInvoice").each(function(beKey,beData){
        if(this.checked){
            let iid = $(this).data("iid");
            if(iid){
                iids.push(parseInt(iid));
            }
        }
    });
    if(iids.length > 0) {
        query += "&iids[]="+iids.join("&iids[]=");
    }
    beClassRequestItem($(this),"{{ beGetRoute('client.invoice.process.post') }}","action=merge"+query);
    return false;
});
</script>
@endsection