<div class="card mb-3">
	<div class="card-header mb-3">
        <div>
            <h3>
                Havale / EFT İle Ödeme
            </h3>
        </div>
	</div>
	<div class="card-content">
        <form id="bankForm">
            <input type="hidden" name="onprocess" value="1">
            <input type="hidden" name="iid" value="{{ $invoice['iid'] }}">
            <input type="hidden" name="method" value="bank">
            <div class="row">
                <div class="col-6 col-md-12 mb-3">
                    <div class="form-group">
                        <label for="user">Gönderici Adı Soyadı</label>
                        <input type="text" class="form-control" name="user" id="user" required="required" value="{{ $be->user['name'].' '.$be->user['surname'] }}">
                    </div>
                </div>
                <div class="col-6 col-md-12 mb-3">
                    <div class="form-group">
                        <label for="#">Gönderilen Hesabımız</label>
                        <select class="form-control" name="bank">
                            @foreach($banks as $bank)
                            <option value="{{ $bank['bid'] }}">{{ $bank['bname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <hr>
            </div>
            <div class="row">
                <div class="row col-12 mt-3">
                    <table class="btable">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Adet</th>
                                <th>Adet Fiyatı</th>
                                <th>Vergi Oranı</th>
                                <th>Toplam</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice['items'] as $item)
                            <tr>
                                <td>{{ $item['iiname'] }}</td>
                                <td><span class="text-success">{{ $item['iiunitcount'] }}</span> Adet</td>
                                <td>%{{ $item['iiunitprice'] }}</td>
                                <td>%{{ $item['iitaxrate'] }}</td>
                                <td>+{{ $item['iiunitprice']*$item['iiunitcount'] }}{{ $currencies[$item['cid']]['cicon'] }}</td>
                            </tr>
                            @endforeach
                            @if($invoice['itaxprice'] > 0)
                            <tr>
                                <td>Katma Değer Vergisi</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>+{{ beMoneyFormat($invoice['itaxprice']) }}{{ $currencies[$invoice['cid']]['cicon'] }}</td>
                            </tr>
                            @endif
                            @if($invoice['idiscount'] > 0)
                            <tr>
                                <td>İndirim</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-{{ beMoneyFormat($invoice['idiscount']) }}{{ $currencies[$invoice['cid']]['cicon'] }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td>TOPLAM</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td><span class="text-success">{{ beMoneyFormat($invoice['itotal']) }}{{ $currencies[$invoice['cid']]['cicon'] }}</span></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
        <div class="row mt-3">
			<div class="col-12 row-flex row-center">
				<a href="#" class="btn btn-special beCallRequest" data-form="bank" data-url="{{ beGetRoute('client.invoice.invoice.post') }}">Ödemeyi Gönderdim</a>
			</div>
		</div>
	</div>	
</div>
<div class="row">
    @foreach($banks as $bank)
    <div class="col-6 col-md-12">
        <div class="card">
            <div class="card-content row-stack row-column">
                <div class="mb-3">
                    <img src="app/resources/upload/bank/{{ $bank['bimage'] }}" width="300" height="100">
                </div>
                <div class="mb-2"><span class="text-hard text-lg">{{ strtoupper($bank['bname']) }}</span></div>
                <div class="mb-1"><span class="text-hard">Hesap Adı:</span> <span class="text-normal">{{ $bank['buser'] }}</span></div>
                <div><span class="text-hard">IBAN:</span> <span class="text-normal">{{ $bank['biban'] }}</span></div>
            </div>
        </div>
    </div>
    @endforeach
</div>