<style>
    .beSelectCard.selected {
        border: 2px solid #009ef7;
    }
	.form-group:not(:first-child) {
		margin: 20px 0px;
	}
	.form-group label {
		color: #6c757d;
	}
	.input-select {
		display: flex;
		justify-content: space-between;
	}
	.input-select input {
		width: 70%!important;
	}
	.input-select select {
		width: 20%!important;
	}
	.sinfo-description {
		padding: 15px 20px;
		border-radius: 5px;
		background: var(--header-right);
		color: #fff;
		box-shadow: 0 0.125rem 0.25rem rgb(0 0 0 / 8%);		
	}
	.sinfo-description a {
		color: #fff;
		opacity: .8;
		font-size: 16px;
	}
	.sinfo-description a:hover {
		opacity: 1;
	}
    .input-group {
        position: relative;
    }
    .input-group input {
        text-indent: 35px;
        height: 50px;
    }
    .input-group input[type="tel"]{
        width: 100%;
        text-indent: 15px;
    }
    .input-icon {
        width: 40px;
        height: 50px;
        position: absolute;
        z-index: 4;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .icon-info {
        right: 0;
    }
    .input-icon i {
        color: #b1b1b1;
        font-size: 18px;
    }
    #ccsingle {
        position: absolute;
        right: 15px;
        top: 20px;
    }
    #ccsingle svg {
        width: 100px;
        max-height: 60px;
    }
    .creditcard svg#cardfront,
    .creditcard svg#cardback {
        width: 100%;
        -webkit-box-shadow: 1px 5px 6px 0px black;
        box-shadow: 1px 5px 6px 0px black;
        border-radius: 22px;
    }
    #generatecard{
        cursor: pointer;
        float: right;
        font-size: 12px;
        color: #fff;
        padding: 2px 4px;
        background-color: #909090;
        border-radius: 4px;
        cursor: pointer;
        float:right;
    }
    .creditcard .lightcolor,
    .creditcard .darkcolor {
        -webkit-transition: fill .5s;
        transition: fill .5s;
    }

    .creditcard .lightblue {
        fill: #03A9F4;
    }

    .creditcard .lightbluedark {
        fill: #0288D1;
    }

    .creditcard .red {
        fill: #ef5350;
    }

    .creditcard .reddark {
        fill: #d32f2f;
    }

    .creditcard .purple {
        fill: #ab47bc;
    }

    .creditcard .purpledark {
        fill: #7b1fa2;
    }

    .creditcard .cyan {
        fill: #26c6da;
    }

    .creditcard .cyandark {
        fill: #0097a7;
    }

    .creditcard .green {
        fill: #66bb6a;
    }

    .creditcard .greendark {
        fill: #388e3c;
    }

    .creditcard .lime {
        fill: #d4e157;
    }

    .creditcard .limedark {
        fill: #afb42b;
    }

    .creditcard .yellow {
        fill: #ffeb3b;
    }

    .creditcard .yellowdark {
        fill: #f9a825;
    }

    .creditcard .orange {
        fill: #ff9800;
    }

    .creditcard .orangedark {
        fill: #ef6c00;
    }

    .creditcard .grey {
        fill: #bdbdbd;
    }

    .creditcard .greydark {
        fill: #616161;
    }

    /* FRONT OF CARD */
    #svgname {
        text-transform: uppercase;
    }

    #cardfront .st2 {
        fill: #FFFFFF;
    }

    #cardfront .st3 {
        font-weight: 600;
    }

    #cardfront .st4 {
        font-size: 54.7817px;
    }

    #cardfront .st5 {
        font-weight: 400;
    }

    #cardfront .st6 {
        font-size: 33.1112px;
    }

    #cardfront .st7 {
        opacity: 0.6;
        fill: #FFFFFF;
    }

    #cardfront .st8 {
        font-size: 24px;
    }

    #cardfront .st9 {
        font-size: 36.5498px;
    }

    #cardfront .st10 {
        font-weight: 300;
    }

    #cardfront .st11 {
        font-size: 16.1716px;
    }

    #cardfront .st12 {
        fill: #4C4C4C;
    }

    /* BACK OF CARD */
    #cardback .st0 {
        fill: none;
        stroke: #0F0F0F;
        stroke-miterlimit: 10;
    }

    #cardback .st2 {
        fill: #111111;
    }

    #cardback .st3 {
        fill: #F2F2F2;
    }

    #cardback .st4 {
        fill: #D8D2DB;
    }

    #cardback .st5 {
        fill: #C4C4C4;
    }

    #cardback .st6 {
        font-weight: 400;
    }

    #cardback .st7 {
        font-size: 27px;
    }

    #cardback .st8 {
        opacity: 0.6;
    }

    #cardback .st9 {
        fill: #FFFFFF;
    }

    #cardback .st10 {
        font-size: 24px;
    }

    #cardback .st11 {
        fill: #EAEAEA;
    }
    #cardback .st13 {
        font-size: 37.769px;
    }

    /* FLIP ANIMATION */
    .container {
        perspective: 1000px;
    }

    .creditcard {
        width: 100%;
        max-width: 400px;
        -webkit-transform-style: preserve-3d;
        transform-style: preserve-3d;
        transition: -webkit-transform 0.6s;
        -webkit-transition: -webkit-transform 0.6s;
        transition: transform 0.6s;
        transition: transform 0.6s, -webkit-transform 0.6s;
        cursor: pointer;
    }

    .creditcard .front,
    .creditcard .back {
        position: absolute;
        width: 100%;
        max-width: 400px;
        -webkit-backface-visibility: hidden;
        backface-visibility: hidden;
        -webkit-font-smoothing: antialiased;
        color: #47525d;
    }

    .creditcard .back {
        -webkit-transform: rotateY(180deg);
        transform: rotateY(180deg);
    }

    .creditcard.flipped {
        -webkit-transform: rotateY(180deg);
        transform: rotateY(180deg);
    }

    .btable td:nth-child(1){
        text-align: start;
        padding-left: 10px;
    }

</style>
<div class="card">
	<div class="card-header mb-3">
        <div>
            <h3>
                Kart Bilgileriniz
            </h3>
        </div>
        @if($usercards)
        <div>
            <a class="btn btn-transparent beActivateCardArea" href="#" style="color:#fff;border: 1px solid #fff;color: #fff!important;border: 1px solid #fff!important;">Başka bir kart ile ödeme yap</a>
        </div>
        @endif
	</div>
	<div class="card-content">
        <form id="cardForm">
            <div class="row">
                @if($settings['iyzico_store_card'] == 1 && $usercards)
                <div class="row col-12 mb-5">
                    @php $cardtext = " selected" @endphp
                    @foreach($usercards as $usercard)
                    <div class="col-4">
                        <div class="beSelectCard card p-3{{ $cardtext }}" data-cid="{{ $usercard['icid'] }}">
                            <div class="row">
                                <div class="row col-12 row-space row-align mb-3">
                                    <div class="p-0">
                                        <span class="text-hard text-lg">{{ $usercard['icname'] }}</span>
                                    </div>
                                    <div>
                                        <a class="text-danger beCallRequest" href="#" data-url="{{ beGetRoute('iyzico.card.delete.post') }}" data-data="cid={{ $usercard['icid'] }}"><i class="ri-close-line"></i></a>
                                    </div>
                                </div>
                                <div class="row col-12 row-flex row-space row-align">
                                    <div class="p-0">
                                        <span class="text-hard text-sm">{{ $usercard['icbinnumber'] }}******{{ $usercard['iclastfour'] }}</span>
                                    </div>
                                    <div class="p-0">
                                        <img src="assets/payment_logo/{{ strtolower($usercard['icassociation']) }}.svg" width="34" height="30" alt="{{ $usercard['icassociation'] }}" title="{{ $usercard['icassociation'] }}" crossorigin="anonymous">
                                        @if(!beFileExits('assets/payment_logo/family/'.strtolower($usercard['icfamily']).'.webp'))
                                        <img src="assets/payment_logo/banks/{{ strtolower($usercard['icbankname']) }}.jpg" width="50" height="30" alt="{{ $usercard['icbankname'] }}" title="{{ $usercard['icbankname'] }}" crossorigin="anonymous">
                                        @else
                                        <img src="assets/payment_logo/family/{{ strtolower($usercard['icfamily']) }}.webp" width="60" height="30" alt="{{ $usercard['icfamily'] }}" title="{{ $usercard['icfamily'] }}" crossorigin="anonymous">
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @php $cardtext = ""; @endphp
                    @endforeach
                    <div class="col-4">
                        <div class="card h-100 row-flex row-center row-align">
                            <div>
                                <div class="text-center">
                                    <i class="text-lg ri-add-line"></i>
                                </div>
                                <div>
                                    <a class="text-normal beActivateCardArea" href="#">Başka bir kart ile ödeme yap</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                <div class="col-12 row beCardArea{{ $usercards ? ' row-none':'' }}">
                    <div class="row col-6 col-md-12 mb-3">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="pb-1">Kart Numarası</label>
                                <div class="input-group">
                                    <div class="input-icon"> 
                                        <i class="ri-bank-card-2-line"></i>
                                    </div>
                                    <input type="text" class="form-control" value="" id="cardNumer" name="cardNumer">
                                </div>
                            </div>
                        </div>
                        <div class="col-12 mt-3">
                            <div class="form-group">
                                <label class="pb-1">Kart Sahibinin Adı Soyadı</label>
                                <div class="input-group">
                                    <div class="input-icon"> 
                                        <i class="ri-user-line"></i>
                                    </div>
                                    <input type="text" class="form-control" value="{{ $user['name'].' '.$user['surname'] }}" id="cardUser" name="cardUser">
                                </div>
                            </div>
                        </div>
                        <div class="col-6 mt-3">
                            <div class="form-group">
                                <label class="pb-1">Son Kullanım Tarihi</label>
                                <div class="input-group">
                                    <div class="input-icon"> 
                                        <i class="ri-calendar-line"></i>
                                    </div>
                                    <input type="text" class="form-control" value="" placeholder="MM / YY" id="cardValidate" name="cardValidate">
                                </div>
                            </div>
                        </div>
                        <div class="col-6 mt-3">
                            <div class="form-group">
                                <label class="pb-1">CVV</label>
                                <div class="input-group">
                                    <div class="input-icon"> 
                                        <i class="ri-lock-line"></i>
                                    </div>
                                    <input type="text" class="form-control" value="" placeholder="CVV" id="cardCvc" name="cardCvc">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row col-6 desktoparea">
                        <div class="creditcard">
                            <div class="front">
                                <div id="ccsingle"></div>
                                <svg version="1.1" id="cardfront" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 750 471" style="enable-background:new 0 0 750 471;" xml:space="preserve">
                                    <g id="Front">
                                        <g id="CardBackground">
                                            <g id="Page-1_1_">
                                                <g id="amex_1_">
                                                    <path id="Rectangle-1_1_" class="lightcolor black" d="M40,0h670c22.1,0,40,17.9,40,40v391c0,22.1-17.9,40-40,40H40c-22.1,0-40-17.9-40-40V40 C0,17.9,17.9,0,40,0z"></path>
                                                </g>
                                            </g>
                                            <path class="darkcolor reddark" d="M750,431V193.2c-217.6-57.5-556.4-13.5-750,24.9V431c0,22.1,17.9,40,40,40h670C732.1,471,750,453.1,750,431z"></path>
                                        </g>
                                        <text transform="matrix(1 0 0 1 60.106 295.0121)" id="svgnumber" class="st2 st3 st4">0123 4567 8910 1112</text>
                                        <text transform="matrix(1 0 0 1 54.1064 428.1723)" id="svgname" class="st2 st5 st6">{{ beGetConfig('sitename') }}</text>
                                        <text transform="matrix(1 0 0 1 54.1074 389.8793)" class="st7 st5 st8">Kart Sahibi</text>
                                        <text transform="matrix(1 0 0 1 479.7754 388.8793)" class="st7 st5 st8">Bitiş Tarihi</text>
                                        <text transform="matrix(1 0 0 1 65.1054 241.5)" class="st7 st5 st8">Kart Numarası</text>
                                        <g>
                                            <text transform="matrix(1 0 0 1 574.4219 433.8095)" id="svgexpire" class="st2 st5 st9">01/23</text>
                                            <text transform="matrix(1 0 0 1 479.3848 417.0097)" class="st2 st10 st11">AY</text>
                                            <text transform="matrix(1 0 0 1 479.3848 435.6762)" class="st2 st10 st11">YIL</text>
                                            <polygon class="st2" points="554.5,421 540.4,414.2 540.4,427.9 		"></polygon>
                                        </g>
                                        <g id="cchip">
                                            <g>
                                                <path class="st2" d="M168.1,143.6H82.9c-10.2,0-18.5-8.3-18.5-18.5V74.9c0-10.2,8.3-18.5,18.5-18.5h85.3
                                        c10.2,0,18.5,8.3,18.5,18.5v50.2C186.6,135.3,178.3,143.6,168.1,143.6z"></path>
                                            </g>
                                            <g>
                                                <g>
                                                    <rect x="82" y="70" class="st12" width="1.5" height="60"></rect>
                                                </g>
                                                <g>
                                                    <rect x="167.4" y="70" class="st12" width="1.5" height="60"></rect>
                                                </g>
                                                <g>
                                                    <path class="st12" d="M125.5,130.8c-10.2,0-18.5-8.3-18.5-18.5c0-4.6,1.7-8.9,4.7-12.3c-3-3.4-4.7-7.7-4.7-12.3
                                            c0-10.2,8.3-18.5,18.5-18.5s18.5,8.3,18.5,18.5c0,4.6-1.7,8.9-4.7,12.3c3,3.4,4.7,7.7,4.7,12.3
                                            C143.9,122.5,135.7,130.8,125.5,130.8z M125.5,70.8c-9.3,0-16.9,7.6-16.9,16.9c0,4.4,1.7,8.6,4.8,11.8l0.5,0.5l-0.5,0.5
                                            c-3.1,3.2-4.8,7.4-4.8,11.8c0,9.3,7.6,16.9,16.9,16.9s16.9-7.6,16.9-16.9c0-4.4-1.7-8.6-4.8-11.8l-0.5-0.5l0.5-0.5
                                            c3.1-3.2,4.8-7.4,4.8-11.8C142.4,78.4,134.8,70.8,125.5,70.8z"></path>
                                                </g>
                                                <g>
                                                    <rect x="82.8" y="82.1" class="st12" width="25.8" height="1.5"></rect>
                                                </g>
                                                <g>
                                                    <rect x="82.8" y="117.9" class="st12" width="26.1" height="1.5"></rect>
                                                </g>
                                                <g>
                                                    <rect x="142.4" y="82.1" class="st12" width="25.8" height="1.5"></rect>
                                                </g>
                                                <g>
                                                    <rect x="142" y="117.9" class="st12" width="26.2" height="1.5"></rect>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                    <g id="Back">
                                    </g>
                                </svg>
                            </div>
                            <div class="back">
                                <svg version="1.1" id="cardback" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 750 471" style="enable-background:new 0 0 750 471;" xml:space="preserve">
                                    <g id="Front">
                                        <line class="st0" x1="35.3" y1="10.4" x2="36.7" y2="11"></line>
                                    </g>
                                    <g id="Back">
                                        <g id="Page-1_2_">
                                            <g id="amex_2_">
                                                <path id="Rectangle-1_2_" class="darkcolor greydark" d="M40,0h670c22.1,0,40,17.9,40,40v391c0,22.1-17.9,40-40,40H40c-22.1,0-40-17.9-40-40V40
                                        C0,17.9,17.9,0,40,0z"></path>
                                            </g>
                                        </g>
                                        <rect y="61.6" class="st2" width="750" height="78"></rect>
                                        <g>
                                            <path class="st3" d="M701.1,249.1H48.9c-3.3,0-6-2.7-6-6v-52.5c0-3.3,2.7-6,6-6h652.1c3.3,0,6,2.7,6,6v52.5
                                    C707.1,246.4,704.4,249.1,701.1,249.1z"></path>
                                            <rect x="42.9" y="198.6" class="st4" width="664.1" height="10.5"></rect>
                                            <rect x="42.9" y="224.5" class="st4" width="664.1" height="10.5"></rect>
                                            <path class="st5" d="M701.1,184.6H618h-8h-10v64.5h10h8h83.1c3.3,0,6-2.7,6-6v-52.5C707.1,187.3,704.4,184.6,701.1,184.6z"></path>
                                        </g>
                                        <text transform="matrix(1 0 0 1 621.999 227.2734)" id="svgsecurity" class="st6 st7">111</text>
                                        <g class="st8">
                                            <text transform="matrix(1 0 0 1 518.083 280.0879)" class="st9 st6 st10">CVV</text>
                                        </g>
                                        <rect x="58.1" y="378.6" class="st11" width="375.5" height="13.5"></rect>
                                        <rect x="58.1" y="405.6" class="st11" width="421.7" height="13.5"></rect>
                                        <text transform="matrix(1 0 0 1 59.5073 228.6099)" id="svgnameback" class="st12 st13">NETVAY</text>
                                    </g>
                                </svg>
                            </div>
                        </div>
                    </div>
                    @if($settings['iyzico_store_card'] == 1)
                    <div class="col-12 my-5">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <div class="form-check form-check-custom form-check-solid">
                                    <input type="hidden" name="savecard" value="0">
                                    <input class="form-check-input" type="checkbox" value="1" name="savecard" id="savecard" checked>
                                    <label class="form-check-label" for="savecard">
                                        Bu kartı sonraki kullanımlarım için sakla
                                    </label>
                                </div>
                            </div>
                            <div class="col-6 col-md-12 beCardAlias">
                                <div class="form-group">
                                    <label class="pb-1">Kart Adı</label>
                                    <div class="input-group">
                                        <div class="input-icon"> 
                                            <i class="ri-refund-line"></i>
                                        </div>
                                        <input type="text" class="form-control" name="alias">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
                <div class="row col-12 mt-3 desktoparea">
                    <table class="btable">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Adet</th>
                                <th>Adet Fiyatı</th>
                                <th>Vergi Oranı</th>
                                <th>Toplam</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice['items'] as $item)
                            <tr>
                                <td>{{ $item['iiname'] }}</td>
                                <td><span class="text-success">{{ $item['iiunitcount'] }}</span> Adet</td>
                                <td>{{ $item['iiunitprice'] }}{{ $currencies[$item['cid']]['cicon'] }}</td>
                                <td>%{{ $item['iitaxrate'] }}</td>
                                <td>+{{ $item['iiunitprice']*$item['iiunitcount'] }}{{ $currencies[$item['cid']]['cicon'] }}</td>
                            </tr>
                            @endforeach
                            @if($invoice['itaxprice'] > 0)
                            <tr>
                                <td>Katma Değer Vergisi</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>+{{ beMoneyFormat($invoice['itaxprice']) }}{{ $currencies[$invoice['cid']]['cicon'] }}</td>
                            </tr>
                            @endif
                            @if($invoice['idiscount'] > 0)
                            <tr>
                                <td>İndirim</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-{{ beMoneyFormat($invoice['idiscount']) }}{{ $currencies[$invoice['cid']]['cicon'] }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td>TOPLAM</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td><span class="text-success">{{ beMoneyFormat($invoice['itotal']) }}{{ $currencies[$invoice['cid']]['cicon'] }}</span></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="row col-12 mt-3 mobilearea" style="display: none;">
                    <table class="btable">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Toplam</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice['items'] as $item)
                            <tr>
                                <td>{{ $item['iiname'] }}</td>
                                <td>+{{ $item['iiunitprice']*$item['iiunitcount'] }}{{ $currencies[$item['cid']]['cicon'] }}</td>
                            </tr>
                            @endforeach
                            @if($invoice['itaxprice'] > 0)
                            <tr>
                                <td>Katma Değer Vergisi</td>
                                <td>+{{ beMoneyFormat($invoice['itaxprice']) }}{{ $currencies[$invoice['cid']]['cicon'] }}</td>
                            </tr>
                            @endif
                            @if($invoice['idiscount'] > 0)
                            <tr>
                                <td>İndirim</td>
                                <td>-{{ beMoneyFormat($invoice['idiscount']) }}{{ $currencies[$invoice['cid']]['cicon'] }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td>TOPLAM</td>
                                <td><span class="text-success">{{ beMoneyFormat($invoice['itotal']) }}{{ $currencies[$invoice['cid']]['cicon'] }}</span></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
        <div class="row mt-3">
			<div class="col-12 row-flex row-center">
				<a href="#" class="btn btn-special btnPay">Ödemeyi Başlat</a>
			</div>
		</div>
	</div>	
</div>
<div id="dataContent">

</div>
<script>
if(document.documentElement.clientWidth<1199){
    $(".mobilearea").show();
    $(".desktoparea").hide();
}
$(".beActivateCardArea").on("click",function(){
    $(".beSelectCard.selected").removeClass("selected");
    $(".beCardArea").removeClass("row-none");
    return false;
});
$(".beSelectCard").on("click",function(){
    $(".beSelectCard.selected").removeClass("selected");
    $(".beSelectCard").addClass("selected");
});
$("#savecard").on("click",function(){
    if($(this).is(":checked")){
        $(".beCardAlias").removeClass("row-none");
    }
    else{
        $(".beCardAlias").addClass("row-none");
    }
});
$("#cardNumer").on("keypress",function(event) {
  let val = $(this).val();
  if (event.charCode >= 48 && event.charCode <= 57) {
    let length = val.length;
    if (length === 3 || length === 9 || length === 15) {
      $(this).val($(this).val() + event.key + "  ");
    }
    else if(length < 22){
        $("#svgnumber").html($(this).val());
        return event.charCode;
    }
  }
  $("#svgnumber").html($(this).val());
  return false;
});
$("#cardNumer").on("input",function(event) {
    if($(".creditcard").hasClass("flipped")){
        $(".creditcard").removeClass("flipped");
    }
    $("#svgnumber").html($(this).val());
});
$("#cardUser").on("input",function(){
    if($(".creditcard").hasClass("flipped")){
        $(".creditcard").removeClass("flipped");
    }
    let val = $(this).val();
    $("#svgname").html(val);
    $("#svgnameback").html(val);
});
$("#cardValidate").on("keypress",function(event) {
  if (event.charCode >= 48 && event.charCode <= 57) {
    if ($(this).val().length === 1) {
      $(this).val($(this).val() + event.key + " / ");
    } else if ($(this).val().length === 0) {
      if (event.key == 1 || event.key == 0) {
        month = event.key;
        $("#svgexpire").html($(this).val());
        return event.charCode;
      } else {
        $(this).val(0 + event.key + "/");
      }
    } else if ($(this).val().length > 4 && $(this).val().length < 7) {
      $("#svgexpire").html($(this).val());
      return event.charCode;
    }
  }
  $("#svgexpire").html($(this).val());
  return false;
}).on("keyup",function(event) {
  if (event.keyCode == 8 && $("#cardValidate").val().length == 2) {
    $(this).val(month);
  }
});
$("#cardValidate").on("input",function(){
    if($(".creditcard").hasClass("flipped")){
        $(".creditcard").removeClass("flipped");
    }
    let val = $(this).val();
    $("#svgexpire").html(val);
});
$("#cardCvc").on("click",function(){
    $(".creditcard").addClass("flipped");
});
$("#cardCvc").on("keypress",function(event) {
  if (event.charCode >= 48 && event.charCode <= 57) {
    if ($(this).val().length >= 0 && $(this).val().length < 3) {
      month = event.key;
      return event.charCode;
    }
  }
  $("#svgsecurity").html($(this).val());
  return false;
});
$("#cardCvc").on("input",function(){
    if(!$(this).hasClass("flipped")){
        $(".creditcard").addClass("flipped");
    }
    let val = $(this).val();
    $("#svgsecurity").html(val);
});
$(".creditcard").on("click",function(){
    if($(this).hasClass("flipped")){
        $(".creditcard").removeClass("flipped");
    }
    else{
        $(".creditcard").addClass("flipped");
    }
});
var wait = false;
$(".btnPay").on("click",function(){
    if(!wait){
        $(".btnPay").html('<i class="spinner ri-refresh-line"></i> Lütfen Bekleyin!');
        var extradata = "";
        var selectedcard = $(".beSelectCard.selected");
        if(selectedcard.length){
            extradata = "&cardid="+selectedcard.data("cid");
        }
        wait = true;
        $.ajax({
            url: "{{ beGetRoute('client.invoice.invoice.post') }}",
            type: "post",
            async: true,
            data: $("#cardForm").serialize()+"&iid={{ $invoice['iid'] }}&method=iyzico&onprocess=1"+extradata,
            dataType: "json",
            crossDomain: true,
            success: function(response){
                $(".btnPay").html("Ödemeyi Başlat");
                if(response.status){
                    $.Toast("Başarılı",response.message,"success");
                    $("#dataContent").append(response.data);
                    setTimeout(function(){
                        $('form[name="returnform"]').submit();
                    },1000);
                }
                else{
                    $.Toast("Bir Hata Oluştu",response.message,"error");
                    wait = false;
                }
            }
        });	
    }
    else{
        $.Toast("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
    }	
    return false;
});
</script>