@extend('layout')
@section('title')
Alan Adını Yapılandır - {{ beGetConfig('sitename') }}
@endsection
@section('headerinclude')
<link href="assets/betheme/css/clientarea.css?ver=19" rel="stylesheet">
<link href="assets/betheme/css/card.css?ver=12" rel="stylesheet">
<link href="assets/betheme/css/col.css?ver=15" rel="stylesheet">
<link href="assets/betheme/css/forms.css?ver=22" rel="stylesheet">
@endsection
@section('content')
<div class="container">
    <div class="card mb-3">
        <div class="card-header">
            <div>
                <span class="card-title"><i class="ri-notification-badge-line"></i> Alan Adı Seçimi</span>
            </div>
        </div>
        <div class="card-content">
            <form id="beSystemForm">
                <div class="row">
                    <div class="col-12 mb-2">
                        <div class="row">
                            <div class="col-12 form-check form-check-custom form-check-solid">
                                <input class="form-check-input" type="radio" value="newdomain" name="domaintype" id="newdomain" checked>
                                <label class="form-check-label" for="newdomain">
                                    Yeni bir alan adı kaydetmek istiyorum.
                                </label>
                            </div>
                            <div class="col-8 p-3 domainarea" id="newdomainarea" style="display: none;">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="domainname1" id="domainname1" required="required" placeholder="Alan adını giriniz">
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group">
                                            <select class="form-control configureSelect" name="domainextension">
                                                <option value=".com" selected="">.com</option>
                                                <option value=".net">.net</option>
                                                <option value=".org">.org</option>
                                                <option value=".biz">.biz</option>
                                                <option value=".info">.info</option>
                                                <option value=".site">.site</option>
                                                <option value=".xyz">.xyz</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 mt-3">
                                        <a href="#" class="btn btn-primary beCallRequest" data-form="beSystem" data-method="get">Kontrol Et</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 mb-2">
                        <div class="form-check form-check-custom form-check-solid">
                            <input class="form-check-input" type="radio" value="transferdomain" name="domaintype" id="transferdomain">
                            <label class="form-check-label" for="transferdomain">
                                Başka bir firmada kayıtlı olan alan adımı size transfer etmek istiyorum.
                            </label>
                        </div>
                        <div class="col-8 p-3 domainarea" id="transferdomainarea" style="display: none;">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="domainname2" id="domainname2" required="required" placeholder="Alan adını giriniz">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 mb-2">
                        <div class="row">
                            <div class="col-12 form-check form-check-custom form-check-solid">
                                <input class="form-check-input" type="radio" value="changedomain" name="domaintype" id="changedomain" checked>
                                <label class="form-check-label" for="changedomain">
                                Mevcut bir alan adım var, sadece isim sunucularını(nameserver) güncellemek istiyorum.
                                </label>
                            </div>
                            <div class="col-8 p-3 domainarea" id="changedomainarea">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="domainname3" id="domainname3" required="required" placeholder="Alan adını giriniz">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 row-center row-flex">
                        <a href="#" class="btn btn-special beCallRequest" data-form="beSystem" data-method="get">Kaydet</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $("input[name='domaintype']").on("change",function(){
        var area = $(this).val();
        $(".domainarea").hide("slow");
        $("#"+area+"area").show("slow");
    });
</script>
@endsection