<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('consolepage_name') }}</span>
                </div>
            </div>
            <div class="card-content">
                <div class="row my-3">
                    <div class="col-12 mb-3 row-flex">
                        <a href="#" class="btn btn-primary btn-sm" id="fullscreen">{{ __('console_fullscreen') }}</a>
                        <a href="#" class="btn btn-primary btn-sm ml-1" id="sendCAD">CTRL+ALT+DELETE</a>
                    </div>
                    <div class="col-12 mb-3">
                        <div class="form-group">
                            <label for="beCommand">{{ __('console_command') }}</label>
                            <div class="form-input-area">
                                <input type="text" class="form-control" id="beCommand">
                                <button class="btn btn-primary" id="beSendCommand">{{ __('console_command_send') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-content">
                <div id="wmksmaincontainer" style="position:relative;width:100%;height:500px">
                    <div id="wmkscontainer" style="position:absolute;left:0;top:0;"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="{{ beGetConfig('siteurl') }}/assets/modules/diyovm/jquery-ui.min.js"></script>
<script src="{{ beGetConfig('siteurl') }}/assets/modules/diyovm/wmks.min.js"></script>
<script>
    var wmks = null;
	$(function() {
		function layout() {
			container.width($("#wmksmaincontainer").width()+"px").height($("#wmksmaincontainer").height()+"px").css("top","20px");
            wmks.setRemoteScreenSize($("#wmksmaincontainer").width(),$("#wmksmaincontainer").height());
		}
		var container = $("#wmkscontainer");
		var fullscreen = $("#fullscreen");
		var sendCAD = $("#sendCAD");
		var beSendCommand = $("#beSendCommand");
		wmks = WMKS.createWMKS("wmkscontainer",{
			keyboardLayoutId: "en-US"
		});
		wmks.register(WMKS.CONST.Events.CONNECTION_STATE_CHANGE, function(evt, data) {
           switch (data.state) {
              case WMKS.CONST.ConnectionState.CONNECTING:
                 break;
              case WMKS.CONST.ConnectionState.CONNECTED:
                 var numMksConnections = "0";
                 if(numMksConnections > 0){
					Swal.fire("Bir Hata Oluştu","There are existing remote console connections to this virtual machine. Proceed with caution or exit the console.","error");
                 }
                 $("#mainCanvas").attr("role","img");
                 $("#mainCanvas").attr("aria-label","beConsole Systems");
                 break;
              case WMKS.CONST.ConnectionState.DISCONNECTED:
                 if(data.reason && data.reason !== ""){
                    Swal.fire("Bir Hata Oluştu",data.reason,"error");
                 } 
				 else{
					Swal.fire("Bir Hata Oluştu","The console has been disconnected. Close this window and re-launch the console to reconnect.","error");
                 }
                 break;
			}
		});
		wmks.register(WMKS.CONST.Events.ERROR, function(evt,data){
            Swal.fire("Bir Hata Oluştu",data.errorType,"error");
		});
		wmks.register(WMKS.CONST.Events.REMOTE_SCREEN_SIZE_CHANGE, function(evt, data){
			layout();
		});
		sendCAD.on("click", function() {
			wmks.sendCAD();
			return false;
		});
		beSendCommand.on("click",function(){
			wmks.sendInputString($("#beCommand").val());
            $("#beCommand").val("");
			return false;
		});
		if(wmks.canFullScreen()){
			fullscreen.on("click",function (evt){
				wmks.enterFullScreen();
				return false;
			});
		} 
		else{
			fullscreen.hide();
		}
		$(window).on("resize",layout);
        wmks.connect("{{ $console_url }}");
        layout();
        wmks.setRemoteScreenSize($("#wmksmaincontainer").width(),$("#wmksmaincontainer").height());
	});
</script>