<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('ippage_rdns_create_name') }}</span>
                </div>
                <div>
                    <a href="#" class="btn btn-primary btn-sm be_button" data-alt-tab="Network"><i class="ri-add-line"></i> {{ __('global_return_back') }}</a>
                </div>
            </div>
            <div class="card-content">
                <form id="rnds_edit{{ $rdns['rid'] }}Form">
                    <input type="hidden" name="rid" value="{{ $rdns['rid'] }}">
                    <div class="row my-3">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label for="Password1">{{ __('ippage_rdns_ip') }}</label>
                                <select class="form-control" name="iid">
                                @foreach($iplist as $ip)
                                    @if($rdns['iid'] == $ip['iid'])
                                    <option value="{{ $ip['iid'] }}" selected>{{ $ip['iaddress'] }}</option>
                                    @else
                                    <option value="{{ $ip['iid'] }}">{{ $ip['iaddress'] }}</option>
                                    @endif
                                @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label for="Password1">{{ __('ippage_rdns_type') }}</label>
                                <select class="form-control" name="type">
                                    @if($rdns['rtype'] == 'PTR')
                                    <option value="PTR" selected>PTR</option>
                                    @else
                                    <option value="PTR">PTR</option>
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label for="Password1">{{ __('ippage_rdns_content') }}</label>
                                <input type="text" class="form-control set-password" name="dns" required="required" value="{{ $rdns['rdns'] }}">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label for="Password1">{{ __('ippage_rdns_priority') }}</label>
                                <input type="number" class="form-control set-password" name="priority" required="required" value="{{ $rdns['rpriority'] }}">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label for="Password1">{{ __('ippage_rdns_ttl') }}</label>
                                <input type="number" class="form-control set-password" name="ttl" required="required" value="{{ $rdns['rttl'] }}">
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-primary beCallRequestx" data-method="rnds_edit" data-form="rnds_edit{{ $rdns['rid'] }}">
                                {{ __('global_update') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>