<div class="row">
    <div class="col-12 mb-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-drag-move-line"></i> {{ __('teamspeak_setting') }}</span>
                </div>
            </div>
            <div class="card-content">
                <form id="editServerForm">
                    <div class="row my-3">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_setting_name') }}</label>
                                <input type="text" class="form-control" name="name" value="{{ $serverinfo['virtualserver_name'] }}">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_setting_welcomemessage') }}</label>
                                <input type="text" class="form-control" name="welcomemessage" value="{{ $serverinfo['virtualserver_welcomemessage'] }}">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_setting_hostmessage') }}</label>
                                <input type="text" class="form-control" name="hostmessage" value="{{ $serverinfo['virtualserver_hostmessage'] }}">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_setting_bannerurl') }}</label>
                                <input type="text" class="form-control" name="bannerurl" value="{{ $serverinfo['virtualserver_hostbanner_url'] }}">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_setting_gfxurl') }}</label>
                                <input type="text" class="form-control" name="gfxurl" value="{{ $serverinfo['virtualserver_hostbanner_gfx_url'] }}">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_setting_hostbuttontooltip') }}</label>
                                <input type="text" class="form-control" name="hostbuttontooltip" value="{{ $serverinfo['virtualserver_hostbutton_tooltip'] }}">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_setting_hostbuttontooltipurl') }}</label>
                                <input type="text" class="form-control" name="hostbuttontooltipurl" value="{{ $serverinfo['virtualserver_hostbutton_url'] }}">
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-primary beCallRequestx" data-method="server_edit" data-form="editServer">
                                {{ __('teamspeak_setting_update') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>