<div class="row">
    <div class="col-12 mb-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('teamspeak_snaphost') }}</span>
                </div>
                <div>
                    <a href="#" class="btn btn-warning btn-sm ml-2 beCallRequestx" data-method="snapshot_create">
                        <i class="ri-sticky-note-add-line"></i>
                        {{ __('teamspeak_snapshot_create') }}
                    </a>
                </div>
            </div>
            <div class="card-content">
                <table class="btable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('teamspeak_snapshot_name') }}</th>
                            <th>{{ __('teamspeak_snapshot_dateline') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($snapshots)
                        @foreach($snapshots as $snapshot)
                        <tr>
                            <td>{{ $snapshot['tsid'] }}</td>
                            <td>{{ $snapshot['tsname'] }}</td>
                            <td>{{ beSpecialTime($snapshot['tsdateline']) }}</td>
                            <td class="row-flex">
                                <a href="#" class="btn btn-success btn-sm beCallRequestx" data-method="snapshot_deploy" data-data="tsid={{ $snapshot['tsid'] }}">
                                    <i class="ri-keyboard-line"></i>
                                    {{ __('teamspeak_snapshot_deploy') }}
                                </a>
                                <a href="#" class="btn btn-danger btn-sm ml-2 beCallRequestx" data-method="snapshot_delete" data-data="tsid={{ $snapshot['tsid'] }}">
                                    <i class="ri-delete-bin-line"></i>
                                    {{ __('teamspeak_snapshot_delete') }}
                                </a>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="3">
                                <div class="beempty">
                                    <div>{{ __('teamspeak_snapshot_empty') }}</div>
                                </div>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-12 mb-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('teamspeak_snaphost') }}</span>
                </div>
            </div>
            <div class="card-content">
                <table class="btable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('teamspeak_snapshot_name') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($defalutsnapshots as $defalutsnapshot)
                        <tr>
                            <td>{{ $defalutsnapshot['tsid'] }}</td>
                            <td>{{ $defalutsnapshot['tsname'] }}</td>
                            <td class="row-flex">
                                <a href="#" class="btn btn-success btn-sm beCallRequestx" data-method="snapshot_deploy" data-data="tsid=-{{ $defalutsnapshot['tsid'] }}">
                                    <i class="ri-keyboard-line"></i>
                                    {{ __('teamspeak_snapshot_deploy') }}
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card mb-3">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-notification-badge-line"></i> {{ beGetLang('teamspeak_snapshot_automation') }}</span>
                </div>
            </div>
            <div class="card-content">
                <form id="beSnapshotSettingForm">
                    <div class="row">
                        <div class="col-12 mb-2">
                            <div class="form-check form-check-custom form-check-solid">
                                <input type="hidden" name="auto_backup" value="0">
                                <input class="form-check-input" type="checkbox" value="1" name="auto_backup" id="auto_backup"{{ $updata['auto_backup'] == 1 ? ' checked':'' }}>
                                <label class="form-check-label" for="auto_backup">
                                    {{ beGetLang('teamspeak_snapshot_automation_status') }}
                                </label>
                            </div>
                        </div>
                        <div class="col-12 mb-2">
                            <div class="form-check form-check-custom form-check-solid">
                                <input type="hidden" name="backup_delete" value="0">
                                <input class="form-check-input" type="checkbox" value="1" name="backup_delete" id="backup_delete"{{ $updata['backup_delete'] == 1 ? ' checked':'' }}>
                                <label class="form-check-label" for="backup_delete">
                                    {{ beGetLang('teamspeak_snapshot_automation_limit') }}
                                </label>
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-special beCallRequestx" data-form="beSnapshotSetting" data-method="snapshot_setting_save">Kaydet</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>