@extend('clientarea.layout')
@section('title')Son Bir Adım Kaldı - {{ beGetConfig('sitename') }}@endsection
@section('content')
<style>
.packets {
    background: rgba(102,112,147,.07);
    border-radius: 8px;
    display: inline-flex;
    padding: 7px 15px;
    width: 310px;
    margin: 15px 0;
    justify-content: space-between;
}
.packets > a {
    display: flex;
    padding: 4px;
    align-items: center;
    transition: .3s;
    width: 47%;
    font-size: 14px;
    color: #667093;
    background: #e3e3e3;
    border-radius: 8px;
    justify-content: center;
    padding: 10px;
}
.packets i {
    font-size: 18px;
    margin-right: 10px;
}
.packets > a.active {
    background: #fff;
    font-weight: 700;
    color: black;
}
.form-group:not(:first-child) {
    margin: 20px 0px;
}
.form-group label {
    color: #6c757d;
}
.input-select {
    display: flex;
    justify-content: space-between;
}
.input-select input {
    width: 70%!important;
}
.input-select select {
    width: 20%!important;
}
.sinfo-description {
    padding: 15px 20px;
    border-radius: 5px;
    background: var(--header-right);
    color: #fff;
    box-shadow: 0 0.125rem 0.25rem rgb(0 0 0 / 8%);
}
</style>
<div class="card">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-coupon-3-line"></i> Son Bir Adım Kaldı</span>
        </div>
    </div>
    <div class="card-content">
        <form id="smsForm" method="post">
            <div class="row mb-3">
                <div class="col-6 mb-3" style="margin: 0 auto;">
                    <div class="text-center mb-1">
                        <img src="assets/betheme/img/sms.svg" width="160">
                    </div>
                    <div class="form-group mb-4">
                        <label for="#">Kod</label>
                        <input type="text" class="form-control" name="code" required="required" placeholder="Telefonunuza gelen doğrulama kodunu giriniz">
                    </div>
                    <div>
                        <span class="text-danger text-sm">SMS Gönderilen Telefon: +{{ $userinfo['uidial'].$userinfo['uiphone'] }}</span>
                    </div>
                    <div>
                        <span class="text-normal text-sm">Telefon numaranıza sistem tarafından talep edilen SMS gönderilmediyse veya mobil cihazınızdan SMS kodunu görüntüleyemiyor iseniz yada telefon numaranızı üyelik oluştururken hatalı girdiyseniz değiştirmek için sistemiz üzerinden bir destek talebi oluşturmanız gerekmektedir.</span>
                    </div>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-icon btn-success beCallRequest mr-2" data-form="sms" data-url="{{ beGetRoute('smsapprove.approve.post') }}">Onayla</a>
                    <a href="{{ beGetRoute('client.ticket.newticket') }}" class="btn btn-danger">Numaramı Değiştir</a>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection