@extend('admin.layout')
@section('headerinclude')
<title>TeamSpeak - Modülü</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Temel Yedek Ekle
                </div>
            </div>
            <div class="card-body">
                <form id="snapshotForm">
                    <div class="row">
                        <div class="col-12 col-md-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sunucu</label>
                            <select class="form-control form-control-select" name="server">
                                @foreach($servers as $server)
                                <option value="{{ $server['sid'] }}">{{ $server['sname'].' # '.$server['surl'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 col-lg-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Yedek Adı</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-12 col-lg-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Yedek Alınacak Sunucu Portu</label>
                            <input type="text" class="form-control" name="port">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addSnapshot">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".addSnapshot").on("click",function(){
        if(!wait){
            $(".addSnapshot").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('teamspeak.snapshot.add.post') }}",
                type: "post",
                async: true,
                data: $("#snapshotForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".addSnapshot").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            location.href = response.url;
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection