@extend('layout')
@section('title')
{{ 'Sepet - '.beGetConfig('sitename') }}
@endsection
@section('headerinclude')
<link href="assets/betheme/css/clientarea.css?ver=19" rel="stylesheet">
<link href="assets/betheme/css/card.css?ver=12" rel="stylesheet">
<link href="assets/betheme/css/col.css?ver=15" rel="stylesheet">
<link href="assets/betheme/css/forms.css?ver=20" rel="stylesheet">
<style>
.table-summary ul {
    list-style: none;
}
.table-summary ul li i {
    margin-right: 5px;
    color: #fff;
}
.table-summary .buttons {
    display: flex;
    justify-content: center;
}
.table-summary .separator {
    height: 1px;
    margin: 15px 0;
    background-color: #fff;
    opacity: .5;
}
.table-data {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin: 16px 0px;
}
.table-summary span {
    color: #fff;
}
.basket {
    display: flex;
}
.basket .logo {
    display: flex;
    align-items: center;
    margin-right: 24px;
    padding-right: 24px;
    border-right: 1px solid #8094AB;
}
.basket .buttons {
    margin-top: 14px;
}
.basket .item .buttons {
    display: flex;
    align-items: center;
}
.basket .item .buttons .counter {
    width: fit-content;
    width: -moz-fit-content;
    display: flex;
    margin-right: 10px;
    border: 1px solid #151b2c;
    border-radius: 10px;
}
.basket .item .buttons .counter > div {
    padding: 4px 10px 4px 10px;
}
.basket .item .buttons .counter .minus,.basket .item .buttons .counter .plus {
    cursor: pointer;
    color: #151b2c;
}
.basket .item .buttons .trash {
    cursor: pointer;
}
.basket .price {
    align-self: flex-end;
    margin-left: auto;
}

.item .item-details {
    display: flex;
    align-items: center;
    color: #646464;
}
.item .item-details span {
    color: #8094AB;
}
.item .item-details i {
    font-size: 8px;
    margin: 0 8px;
    opacity: .2;
}

</style>
@endsection
@section('content')
<div class="container">
    <div class="row">
		<div class="col-9 col-md-12 mb-3" id="productRows">

		</div>
		<div class="col-3 col-md-12">
            <div class="card">
                <div class="card-header" style="border-bottom: 1px solid #fff;">
                    <span>Sipariş Özeti</span>
                </div>
                <div class="card-content table-summary" id="infoTable" style="background:#151b2c;display:none">
                    <ul>
                        <li>
                            <div class="table-data">
                                <span>Ara Toplam</span>
                                <span id="productPrice"></span>
                            </div>
                        </li>
                        <li id="discountArea" style="display:none">
                            <div class="table-data">
                                <span>İndirim</span>
                                <span id="discountPrice"></span>
                            </div>
                        </li>
                        <li>
                            <div class="table-data">
                                <span>KDV(%<span id="taxrate"></span>)</span>
                                <span id="ratePrice"></span>
                            </div>
                        </li>
                        <li class="separator"></li>
                        <li class="coupon mb-3" id="couponArea" style="display:none">
                            <div class="form-group">
                                <input type="text" class="form-control" id="coupon" placeholder="Kupon kodu giriniz" style="color:#fff">
                            </div>
                        </li>
                        <li>
                            <input type="checkbox" id="usecoupon">
                            <label class="text-sm" for="usecoupon"><span>Kupon Kullanmak İstiyorum</span></label>
                        </li>
                        <li class="separator"></li>
                        <li class="mb-2">
                            <div class="table-data">
                                <span>Toplam</span>
                                <span id="totalPrice"></span>
                            </div>
                        </li>
                        <li class="buttons">
                            <a href="#" class="btn btn-primary cartAgreement">Alışverişi Tamamla</a>
                        </li>
                    </ul>
                </div>
                <div class="card-content" id="infoLoading" style="background:#151b2c;display:flex;justify-content:center;align-items:center">
                    <img src="assets/premium/img/loadingnew.gif" style="width:100px;height:100px">
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
	$(document).ready(function(){
		calculateCart();
	});
	var timer = 0;
	$("#usecoupon").change(function() {
		if(this.checked) {
			$("#couponArea").show();
		}
		else{
			$("#couponArea").hide();
		}
	});
	var coupon = "";
	$("#coupon").keyup(function(){
		var text = $(this).val();
		var length = text.length;
		if(length > 2){
			clearInterval(timer);
			timer = setTimeout(function(){
				var lasttext = $("#coupon").val();
				if(lasttext.length == length){
					$.ajax({
						url: "{{ beGetRoute('cart.checkcoupon.post') }}",
						type: "post",
						data: {coupon:lasttext},
						dataType: "json",
						crossDomain: true,
						success: function(response){
							if(response.status){
								coupon = lasttext;
								calculateCart();		
							}
							else{
								toast("Bir Hata Oluştu",response.message,"error");								
							}
						}
					});	
				}
				clearTimeout(timer);
			},500);
		}
	});
	$("#productRows").on("click",".removeProduct",function(){
		var upid = $(this).data("upid");
		$.ajax({
			url: "{{ beGetRoute('cart.remove.post') }}",
			type: "post",
			data: {upid:upid},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					if(response.isempty){
						location.reload();
					}
					else{
						$("#productBack").empty().append(response.oldproduct);
						calculateCart();
					}
					toast("Başarılı",response.message,"success");
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});			
		return false;
	});
    $("#productRows").on("click",".beUpdateCount",function(){
        var upid = $(this).data("upid");
        var counter = $(this).data("counter");
		$.ajax({
			url: "{{ beGetRoute('cart.setcount.post') }}",
			type: "post",
			data: {upid:upid,counter:counter},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					if(response.isempty){
						location.reload();
					}
					else{
						$("#productBack").empty().append(response.oldproduct);
						calculateCart();
					}
					toast("Başarılı",response.message,"success");
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});			
		return false;
    });
	$("#productBack").on("click",".cartAddRetry",function(){
		$.ajax({
			url: "{{ beGetRoute('cart.addretry.post') }}",
			type: "post",
			data: {},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					$("#productBack").empty();
					toast("Başarılı",response.message,"success");
					calculateCart();
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});	
		return false;
	});
	$(".cartAgreement").on("click",function(){
        beClassRequestItem($(this),"{{ beGetRoute('cart.agree.post') }}",{coupon:coupon},function(response){
			if (response.status) {
				$.Toast("Başarılı", response.message, "success");
			} else {
				$.Toast("Bir Sorun Oluştu", response.message, "error");
			}
			if (response.refresh) {
				setTimeout(function() {
					location.reload();
				}, 1000);
			}
			if (response.url) {
				setTimeout(function() {
					window.location.href = response.url;
				}, 1000);
			}
		});
		return false;
	});
	function calculateCart(){
		$("#infoTable").hide();
        $("#infoLoading").css("display","flex");
		$.ajax({
			url: "{{ beGetRoute('cart.get.post') }}",
			type: "post",
			data: {coupon:coupon},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					$("#productRows").empty().append(response.html);
					$("#productPrice").html(response.productsallprice+response.icon);
					if(parseInt(response.productsdiscount) > 0){
						$("#discountArea").show();
						$("#discountPrice").html("-"+response.productsdiscount+response.icon);
					}
					$("#ratePrice").html(response.productsrate+response.icon);
					$("#totalPrice").html(response.totalprice+response.icon);
					$("#taxrate").html(response.taxrate);
					$("#infoTable").show();
                	$("#infoLoading").hide();
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});
	}
</script>
@endsection