<?php

use App\System\Basic\beRouter;
use App\System\Basic\beViewer;
use App\System\Basic\beCache;
use App\System\Basic\beModel;
use App\System\Controller\PageController;
use App\System\Model\CurrencyModel;
use App\System\Model\SettingModel;
use App\System\Model\UserGroupModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;
use App\System\Vendor\bePlugin;


require BE_APPPATH."system/functions.php";
require BE_APPPATH."system/controller.php";
require BE_APPPATH."system/model.php";
require BE_APPPATH."system/configurator.php";
require BE_APPPATH."system/router.php";
require BE_APPPATH."system/viewer.php";
require BE_APPPATH."system/cache.php";
require BE_APPPATH."system/loader.php";
require BE_APPPATH."helper/main.php";

bePlugin::beLoadPlugins();

beGetConfigs("config");

bePlugin::beRunHook("system_load");

$language = @$_COOKIE["be_lang"];
if(!$language){
    $language = "tr";
}
beLanguage::beSetLanguage($language);
beLanguage::beReadLang("global");

beViewer::beSetParams(beGetConfig("path_views"),beGetConfig("path_cache"));
beCache::beSetParams(beGetConfig("path_compiled_cache"));

$be->user = Auth::beGetUser();
$be->user["currency"] = CurrencyModel::beGetCurrencies("cid,cname,cicon",$be->user["cid"]);
if($be->user["uid"]){
    $usergroup = UserGroupModel::beWhere("ugid",$be->user["usergroup"])->beGet();
    $usergroup["ugpermissions"] = json_decode($usergroup["ugpermissions"],true);
    $be->user["username"] = UserGroupModel::beRenderUserName($be->user["name"]." ".$be->user["surname"],$usergroup["ugnamestyle"]);
    $be->user["group"] = $usergroup;
    Auth::beUserAddData("group",$usergroup);
    Auth::beUserAddData("username",$be->user["username"]);
}

$settings = SettingModel::beSelect("scode,svalue,stype")->beWhere("sdefault",1)->beGetAll();
foreach($settings as $setting){
    switch($setting["stype"]){
        case "int" :
            $value = (int)$setting["svalue"];
            break;
        case "float" :
            $value = (float)$setting["svalue"];
            break;
        case "json" :
            $value = json_decode($setting["svalue"],true);
            break;
        default :
            $value = $setting["svalue"];
            break;
    }
    $be->settings[$setting["scode"]] = $value;
}

beGetConfigs("routes");

$status = $be->settings["system_status"];
if($status == 1){
    $route = beRouter::beGetUrl();
    $install = beGetRoute("install");
    if(!in_array($route,["/kurulum","/install-post"])){
        beRouter::beRedirect($install);
    }
}

if(defined("BE_NORMAL")){
    if($be->settings["system_maintenance_mode"] == 1){
        $route = beRouter::beFindActiveRoute();
        $find = false;
        if($route != false){
            if(explode(".",$route)[0] == "admin"){
                $find = true;
            }
        }
        if(!$find){
            $maintenancetext = SettingModel::beGetSettings("system_maintenance_text")["system_maintenance_text"];
            beError("Bakım Modu Aktif",$maintenancetext);
        }
    }
    $view = beRouter::beRun();
    if($view === false){
        beRouter::$beActiveName = "404";
        $page = new PageController();
        bePrintPage($page->page());
    }
    else{
        bePrintPage($view);
    }
}
?>