<?php

namespace App\System\Task;

use App\System\Basic\beModel;
use App\System\Model\SettingModel;
use \Exception;

class ClearLogTask {
    public function run_task($task){
        $settings = SettingModel::beGetSettings("automation_log_clear");
        if($settings["automation_log_clear"] == 0){
            return;
        }
        $checktime = BE_TIME-($settings["automation_log_clear"]*86400);
        beModel::beDelete("be_module_logs")->beWhere("mldateline",$checktime,"<")->beExecute();
        beModel::beDelete("be_system_logs")->beWhere("sldateline",$checktime,"<")->beExecute();
        beModel::beDelete("be_user_logs")->beWhere("ldateline",$checktime,"<")->beExecute();
        beModel::beDelete("be_user_product_logs")->beWhere("upldateline",$checktime,"<")->beExecute();
    }
}

?>