<?php

namespace App\System\Task;

use App\System\Basic\beCache;
use App\System\Model\AccountingModel;
use App\System\Model\TicketModel;
use \Exception;

class GlobalStatsTask {
    public function run_task($task){
        global $be;
        $systemcid = $be->settings["system_currency"];
        $today = strtotime("today");
        $thismonth = strtotime("first day of this month 00:00:00");
        $thisyear = strtotime("first day of january this year");
        $accountingtotals = [
            "thismonth" => 0,
            "thisyear" => 0,
            "alltime" => 0,
        ];
        $accountingtotals["thismonth"] = AccountingModel::beSelect("SUM(atotal) as total")->beWhere("cid",$systemcid)->beWhere("adateline",$thismonth,">")->beWhere("atype","income")->beGet()["total"];
        $monthprices = AccountingModel::beSelect("cid,atotal")->beWhere("cid",$systemcid,"!=")->beWhere("adateline",$thismonth,">")->beWhere("atype","income")->beGetAll();
        foreach($monthprices as $monthprice){
            $accountingtotals["thismonth"] += beConvertCurrencie($monthprice["atotal"],$monthprice["cid"],$systemcid);
        }
        $accountingtotals["thisyear"] = AccountingModel::beSelect("SUM(atotal) as total")->beWhere("cid",$systemcid)->beWhere("adateline",$thisyear,">")->beWhere("atype","income")->beGet()["total"];
        $yearprices = AccountingModel::beSelect("cid,atotal")->beWhere("cid",$systemcid,"!=")->beWhere("adateline",$thisyear,">")->beWhere("atype","income")->beGetAll();
        foreach($yearprices as $yearprice){
            $accountingtotals["thisyear"] += beConvertCurrencie($yearprice["atotal"],$yearprice["cid"],$systemcid);
        }
        $accountingtotals["alltime"] = AccountingModel::beSelect("SUM(atotal) as total")->beWhere("cid",$systemcid)->beWhere("atype","income")->beGet()["total"];
        $allprices = AccountingModel::beSelect("cid,atotal")->beWhere("cid",$systemcid,"!=")->beWhere("atype","income")->beGetAll();
        foreach($allprices as $allprice){
            $accountingtotals["alltime"] += beConvertCurrencie($allprice["atotal"],$allprice["cid"],$systemcid);
        }
        $accountings = AccountingModel::beSelect("cid,atotal,adateline")->beWhere("adateline",$today,">")->beWhere("atype","income")->beGetAll();
        $todayprices = [];
        for($i = 0; $i < 24; $i++){
            $stardate = $today+(3600*$i);
            $enddate = $today+(3600*($i+1));
            $todayprices[$i] = 0;
            foreach($accountings as $accounting){
                if($accounting["adateline"] > $stardate && $accounting["adateline"] < $enddate){
                    $todayprices[$i] += beConvertCurrencie($accounting["atotal"],$accounting["cid"],$systemcid);
                }
            }
            $accountingtotals["today"] += $todayprices[$i];
        }
        beCache::beSetCache("stats_today_prices",json_encode([
            "todayprices" => $todayprices
        ]));
        beCache::beSetCache("stats_times_prices",json_encode([
            "today" => doubleval(round($accountingtotals["today"],2)),
            "thismonth" => doubleval(round($accountingtotals["thismonth"],2)),
            "thisyear" => doubleval(round($accountingtotals["thisyear"],2)),
            "alltime" => doubleval(round($accountingtotals["alltime"],2)),
        ]));
        $tickets = TicketModel::beSelect("tid,tstatus,tdateline")->beWhere("tdateline",$today,">")->beGetAll();
        for($i = 0; $i < 24; $i++){
            $stardate = $today+(3600*$i);
            $enddate = $today+(3600*($i+1));
            $todaytickets["opened"][$i] = 0;
            $todaytickets["closed"][$i] = 0;
            foreach($tickets as $ticket){
                if($ticket["tdateline"] > $stardate && $ticket["tdateline"] < $enddate){
                    if($ticket["tstatus"] == "closed"){
                        $todaytickets["closed"][$i] += 1;
                    }
                    else{
                        $todaytickets["opened"][$i] += 1;
                    }
                }
            }
        }
        beCache::beSetCache("stats_today_tickets",json_encode([
            "todaytickets" => $todaytickets
        ]));
        $tickets = [
            "actiove" => 0,
            "inprocess" => 0
        ];
        $tickets["active"] = TicketModel::beSelect("COUNT(tid) as count")->beWhere("tstatus","active")->beGet()["count"];
        $tickets["inprocess"] = TicketModel::beSelect("COUNT(tid) as count")->beWhere("tstatus","inprocess")->beGet()["count"];
        beCache::beSetCache("stats_tickets",json_encode($tickets));
    }
}

?>